/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.sink;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.sink.TablePlaceholder;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.ConstraintKey;
import org.apache.seatunnel.api.table.catalog.PrimaryKey;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.common.utils.PlaceholderUtils;

public class TablePlaceholderProcessor {
    public static final String NAME_DELIMITER = ".";
    public static final String FIELD_DELIMITER = ",";

    private static String replaceTableIdentifier(String placeholder, TableIdentifier identifier, String defaultValue) {
        placeholder = PlaceholderUtils.replacePlaceholders(placeholder, TablePlaceholder.REPLACE_DATABASE_NAME_KEY.getPlaceholder(), identifier.getDatabaseName(), defaultValue);
        placeholder = PlaceholderUtils.replacePlaceholders(placeholder, TablePlaceholder.REPLACE_SCHEMA_NAME_KEY.getPlaceholder(), identifier.getSchemaName(), defaultValue);
        placeholder = PlaceholderUtils.replacePlaceholders(placeholder, TablePlaceholder.REPLACE_TABLE_NAME_KEY.getPlaceholder(), identifier.getTableName(), defaultValue);
        ArrayList<String> fullPath = new ArrayList<String>();
        if (identifier.getDatabaseName() != null) {
            fullPath.add(identifier.getDatabaseName());
        }
        if (identifier.getSchemaName() != null) {
            fullPath.add(identifier.getSchemaName());
        }
        if (!fullPath.isEmpty()) {
            placeholder = PlaceholderUtils.replacePlaceholders(placeholder, TablePlaceholder.REPLACE_SCHEMA_FULL_NAME_KEY.getPlaceholder(), String.join((CharSequence)NAME_DELIMITER, fullPath), defaultValue);
        }
        if (identifier.getTableName() != null) {
            fullPath.add(identifier.getTableName());
        }
        if (!fullPath.isEmpty()) {
            placeholder = PlaceholderUtils.replacePlaceholders(placeholder, TablePlaceholder.REPLACE_TABLE_FULL_NAME_KEY.getPlaceholder(), String.join((CharSequence)NAME_DELIMITER, fullPath), defaultValue);
        }
        return placeholder;
    }

    public static String replaceTableIdentifier(String placeholder, TableIdentifier identifier) {
        return TablePlaceholderProcessor.replaceTableIdentifier(placeholder, identifier, "");
    }

    public static String replaceTablePrimaryKey(String placeholder, PrimaryKey primaryKey) {
        if (primaryKey != null && !primaryKey.getColumnNames().isEmpty()) {
            String pkFieldsString = String.join((CharSequence)FIELD_DELIMITER, primaryKey.getColumnNames());
            return PlaceholderUtils.replacePlaceholders(placeholder, TablePlaceholder.REPLACE_PRIMARY_KEY.getPlaceholder(), pkFieldsString);
        }
        return placeholder;
    }

    public static String replaceTableUniqueKey(String placeholder, List<ConstraintKey> constraintKeys) {
        Optional<String> ukFieldsString = constraintKeys.stream().filter(e -> e.getConstraintType().equals((Object)ConstraintKey.ConstraintType.UNIQUE_KEY)).findFirst().map(e -> e.getColumnNames().stream().map(f -> f.getColumnName()).collect(Collectors.joining(FIELD_DELIMITER)));
        if (ukFieldsString.isPresent()) {
            return PlaceholderUtils.replacePlaceholders(placeholder, TablePlaceholder.REPLACE_UNIQUE_KEY.getPlaceholder(), ukFieldsString.get());
        }
        return placeholder;
    }

    public static String replaceTableFieldNames(String placeholder, TableSchema schema) {
        return PlaceholderUtils.replacePlaceholders(placeholder, TablePlaceholder.REPLACE_FIELD_NAMES_KEY.getPlaceholder(), String.join((CharSequence)FIELD_DELIMITER, schema.getFieldNames()));
    }

    public static ReadonlyConfig replaceTablePlaceholder(ReadonlyConfig config, CatalogTable table) {
        return TablePlaceholderProcessor.replaceTablePlaceholder(config, table, Collections.emptyList());
    }

    public static ReadonlyConfig replaceTablePlaceholder(ReadonlyConfig config, CatalogTable table, Collection<String> excludeKeys) {
        Map<String, Object> copyOnWriteData = ObjectUtils.clone(config.getSourceMap());
        for (String key : copyOnWriteData.keySet()) {
            List<String> listValue;
            Object value;
            if (excludeKeys.contains(key) || (value = copyOnWriteData.get(key)) == null) continue;
            if (value instanceof String) {
                String strValue = (String)value;
                strValue = TablePlaceholderProcessor.replaceTableIdentifier(strValue, table.getTableId());
                strValue = TablePlaceholderProcessor.replaceTablePrimaryKey(strValue, table.getTableSchema().getPrimaryKey());
                strValue = TablePlaceholderProcessor.replaceTableUniqueKey(strValue, table.getTableSchema().getConstraintKeys());
                strValue = TablePlaceholderProcessor.replaceTableFieldNames(strValue, table.getTableSchema());
                copyOnWriteData.put(key, strValue);
                continue;
            }
            if (!(value instanceof List) || (listValue = (List<String>)value).size() != 1 || !(listValue.get(0) instanceof String)) continue;
            String strValue = (String)listValue.get(0);
            if (strValue.equals("${" + TablePlaceholder.REPLACE_PRIMARY_KEY.getPlaceholder() + "}")) {
                strValue = TablePlaceholderProcessor.replaceTablePrimaryKey(strValue, table.getTableSchema().getPrimaryKey());
                listValue = Arrays.asList(strValue.split(FIELD_DELIMITER));
            } else if (strValue.equals("${" + TablePlaceholder.REPLACE_UNIQUE_KEY.getPlaceholder() + "}")) {
                strValue = TablePlaceholderProcessor.replaceTableUniqueKey(strValue, table.getTableSchema().getConstraintKeys());
                listValue = Arrays.asList(strValue.split(FIELD_DELIMITER));
            } else if (strValue.equals("${" + TablePlaceholder.REPLACE_FIELD_NAMES_KEY.getPlaceholder() + "}")) {
                strValue = TablePlaceholderProcessor.replaceTableFieldNames(strValue, table.getTableSchema());
                listValue = Arrays.asList(strValue.split(FIELD_DELIMITER));
            }
            copyOnWriteData.put(key, listValue);
        }
        return ReadonlyConfig.fromMap(copyOnWriteData);
    }
}

