/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.event.handler;

import java.util.HashMap;
import java.util.Map;
import org.apache.seatunnel.api.table.event.AlterTableAddColumnEvent;
import org.apache.seatunnel.api.table.event.AlterTableChangeColumnEvent;
import org.apache.seatunnel.api.table.event.AlterTableColumnsEvent;
import org.apache.seatunnel.api.table.event.AlterTableDropColumnEvent;
import org.apache.seatunnel.api.table.event.AlterTableEvent;
import org.apache.seatunnel.api.table.event.AlterTableModifyColumnEvent;
import org.apache.seatunnel.api.table.event.AlterTableNameEvent;
import org.apache.seatunnel.api.table.event.SchemaChangeEvent;
import org.apache.seatunnel.api.table.event.handler.AlterTableEventHandler;
import org.apache.seatunnel.api.table.event.handler.DataTypeChangeEventHandler;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTypeChangeEventDispatcher
implements DataTypeChangeEventHandler {
    private static final Logger log = LoggerFactory.getLogger(DataTypeChangeEventDispatcher.class);
    private final Map<Class, DataTypeChangeEventHandler> handlers = DataTypeChangeEventDispatcher.createHandlers();
    private SeaTunnelRowType dataType;

    @Override
    public SeaTunnelRowType get() {
        return this.dataType;
    }

    @Override
    public DataTypeChangeEventHandler reset(SeaTunnelRowType dataType) {
        this.dataType = dataType;
        return this;
    }

    @Override
    public SeaTunnelRowType apply(SchemaChangeEvent event) {
        DataTypeChangeEventHandler handler = this.handlers.get(event.getClass());
        if (handler == null) {
            log.warn("No DataTypeChangeEventHandler for event: {}", (Object)event.getClass());
            return this.dataType;
        }
        return handler.reset(this.dataType).apply(event);
    }

    private static Map<Class, DataTypeChangeEventHandler> createHandlers() {
        HashMap<Class, DataTypeChangeEventHandler> handlers = new HashMap<Class, DataTypeChangeEventHandler>();
        AlterTableEventHandler alterTableEventHandler = new AlterTableEventHandler();
        handlers.put(AlterTableEvent.class, alterTableEventHandler);
        handlers.put(AlterTableNameEvent.class, alterTableEventHandler);
        handlers.put(AlterTableColumnsEvent.class, alterTableEventHandler);
        handlers.put(AlterTableAddColumnEvent.class, alterTableEventHandler);
        handlers.put(AlterTableModifyColumnEvent.class, alterTableEventHandler);
        handlers.put(AlterTableDropColumnEvent.class, alterTableEventHandler);
        handlers.put(AlterTableChangeColumnEvent.class, alterTableEventHandler);
        return handlers;
    }
}

