/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.cache;

import com.hazelcast.cache.impl.CacheKeysWithCursor;
import com.hazelcast.cache.impl.CacheOperationProvider;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheIterateCodec;
import com.hazelcast.client.impl.protocol.task.cache.AbstractCacheMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.iteration.IterationPointer;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.util.Collections;

public class CacheIterateMessageTask
extends AbstractCacheMessageTask<CacheIterateCodec.RequestParameters> {
    public CacheIterateMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Operation prepareOperation() {
        CacheOperationProvider operationProvider = this.getOperationProvider(((CacheIterateCodec.RequestParameters)this.parameters).name);
        IterationPointer[] pointers = IterationPointer.decodePointers(((CacheIterateCodec.RequestParameters)this.parameters).iterationPointers);
        return operationProvider.createFetchKeysOperation(pointers, ((CacheIterateCodec.RequestParameters)this.parameters).batch);
    }

    @Override
    protected CacheIterateCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return CacheIterateCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        if (response == null) {
            return CacheIterateCodec.encodeResponse(Collections.emptyList(), Collections.emptyList());
        }
        CacheKeysWithCursor keyIteratorResult = (CacheKeysWithCursor)response;
        IterationPointer[] pointers = keyIteratorResult.getPointers();
        return CacheIterateCodec.encodeResponse(IterationPointer.encodePointers(pointers), keyIteratorResult.getKeys());
    }

    @Override
    public String getDistributedObjectName() {
        return ((CacheIterateCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "iterator";
    }
}

