/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.jet.JetException;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JobResult
implements IdentifiedDataSerializable {
    private long jobId;
    private JobConfig jobConfig;
    private long creationTime;
    private long completionTime;
    private String failureText;

    public JobResult() {
    }

    JobResult(long jobId, @Nonnull JobConfig jobConfig, long creationTime, long completionTime, @Nullable String failureText) {
        this.jobId = jobId;
        this.jobConfig = jobConfig;
        this.creationTime = creationTime;
        this.completionTime = completionTime;
        this.failureText = failureText;
    }

    public long getJobId() {
        return this.jobId;
    }

    @Nonnull
    public JobConfig getJobConfig() {
        return this.jobConfig;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getCompletionTime() {
        return this.completionTime;
    }

    public boolean isSuccessful() {
        return this.failureText == null;
    }

    @Nullable
    public String getFailureText() {
        return this.failureText;
    }

    @Nullable
    public Throwable getFailureAsThrowable() {
        RuntimeException throwable;
        if (this.failureText == null) {
            return null;
        }
        if (this.failureText.startsWith(CancellationException.class.getName())) {
            int prefixLength = (CancellationException.class.getName() + ": ").length();
            String message = this.failureText.length() >= prefixLength ? this.failureText.substring(prefixLength) : null;
            throwable = new CancellationException(message);
        } else {
            throwable = new JetException(this.failureText);
        }
        return throwable;
    }

    @Nonnull
    public JobStatus getJobStatus() {
        return this.isSuccessful() ? JobStatus.COMPLETED : JobStatus.FAILED;
    }

    @Nonnull
    CompletableFuture<Void> asCompletableFuture() {
        return this.failureText == null ? CompletableFuture.completedFuture(null) : Util.exceptionallyCompletedFuture(this.getFailureAsThrowable());
    }

    @Nonnull
    public String getJobNameOrId() {
        return this.jobConfig.getName() != null ? this.jobConfig.getName() : com.hazelcast.jet.Util.idToString(this.jobId);
    }

    public String toString() {
        return "JobResult{jobId=" + com.hazelcast.jet.Util.idToString(this.jobId) + ", name=" + this.jobConfig.getName() + ", creationTime=" + Util.toLocalDateTime(this.creationTime) + ", completionTime=" + Util.toLocalDateTime(this.completionTime) + ", failureText=" + this.failureText + '}';
    }

    @Override
    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 4;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.jobId);
        out.writeObject(this.jobConfig);
        out.writeLong(this.creationTime);
        out.writeLong(this.completionTime);
        out.writeObject(this.failureText);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.jobId = in.readLong();
        this.jobConfig = (JobConfig)in.readObject();
        this.creationTime = in.readLong();
        this.completionTime = in.readLong();
        this.failureText = (String)in.readObject();
    }
}

