/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.predicate;

import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.expression.BiExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.Searchable;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;

public final class SearchPredicate
extends BiExpression<Boolean>
implements IdentifiedDataSerializable {
    public SearchPredicate() {
    }

    private SearchPredicate(Expression<?> left, Expression<?> right) {
        super(left, right);
    }

    public static SearchPredicate create(Expression<?> left, Expression<?> right) {
        assert (left.getType().equals(right.getType()));
        return new SearchPredicate(left, right);
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 60;
    }

    @Override
    public Boolean eval(Row row, ExpressionEvalContext context) {
        Object left = this.operand1.eval(row, context);
        if (left == null) {
            return null;
        }
        Object right = this.operand2.eval(row, context);
        if (right == null) {
            return null;
        }
        Comparable needle = (Comparable)left;
        Searchable searchable = (Searchable)right;
        return searchable.contains(needle);
    }

    @Override
    public QueryDataType getType() {
        return QueryDataType.BOOLEAN;
    }
}

