/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.management;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MCWanSyncMapCodec;
import com.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.security.permission.ManagementPermission;
import com.hazelcast.wan.impl.WanSyncType;
import java.security.Permission;
import java.util.UUID;

public class WanSyncMapMessageTask
extends AbstractCallableMessageTask<MCWanSyncMapCodec.RequestParameters> {
    private static final Permission REQUIRED_PERMISSION = new ManagementPermission("wan.syncMap");

    public WanSyncMapMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object call() throws Exception {
        WanSyncType wanSyncType = WanSyncType.getByType(((MCWanSyncMapCodec.RequestParameters)this.parameters).wanSyncType);
        if (wanSyncType == null) {
            throw new IllegalArgumentException(String.format("Invalid wanSyncType: %s", ((MCWanSyncMapCodec.RequestParameters)this.parameters).wanSyncType));
        }
        switch (wanSyncType) {
            case ALL_MAPS: {
                return this.syncAllMaps();
            }
            case SINGLE_MAP: {
                return this.syncSingleMap();
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported wanSyncType: %s", ((MCWanSyncMapCodec.RequestParameters)this.parameters).wanSyncType));
    }

    private UUID syncSingleMap() {
        return this.nodeEngine.getWanReplicationService().syncMap(((MCWanSyncMapCodec.RequestParameters)this.parameters).wanReplicationName, ((MCWanSyncMapCodec.RequestParameters)this.parameters).wanPublisherId, ((MCWanSyncMapCodec.RequestParameters)this.parameters).mapName);
    }

    private UUID syncAllMaps() {
        return this.nodeEngine.getWanReplicationService().syncAllMaps(((MCWanSyncMapCodec.RequestParameters)this.parameters).wanReplicationName, ((MCWanSyncMapCodec.RequestParameters)this.parameters).wanPublisherId);
    }

    @Override
    protected MCWanSyncMapCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MCWanSyncMapCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MCWanSyncMapCodec.encodeResponse((UUID)response);
    }

    @Override
    public String getServiceName() {
        return "hz:core:wanReplicationService";
    }

    @Override
    public Permission getRequiredPermission() {
        return REQUIRED_PERMISSION;
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "wanSyncMap";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{((MCWanSyncMapCodec.RequestParameters)this.parameters).wanReplicationName, ((MCWanSyncMapCodec.RequestParameters)this.parameters).wanPublisherId, ((MCWanSyncMapCodec.RequestParameters)this.parameters).wanSyncType, ((MCWanSyncMapCodec.RequestParameters)this.parameters).mapName};
    }

    @Override
    public boolean isManagementTask() {
        return true;
    }
}

