/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance.impl;

import com.hazelcast.config.IntegrityCheckerConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.serialization.DataSerializerHook;
import com.hazelcast.internal.util.ServiceLoader;
import com.hazelcast.io.github.classgraph.ClassGraph;
import com.hazelcast.io.github.classgraph.ClassInfo;
import com.hazelcast.logging.ILogger;
import java.util.List;
import java.util.stream.Collectors;

public final class IntegrityChecker {
    private static final String FACTORY_ID = "com.hazelcast.DataSerializerHook";
    private static final String INTEGRITY_CHECKER_IS_DISABLED = "Integrity Checker is disabled. Fail-fast on corrupted executables will not be performed.\nTo enable integrity checker do one of the following: \n" + String.format("  - Change member config using Java API: %s\n  - Change XML/YAML configuration property: Set %s\n  - Add system property: %s (for Hazelcast embedded, works only when loading config via Config.load)\n  - Add environment variable: %s (recommended when running container image. For Hazelcast embedded, works only when loading config via Config.load)", "config.setIntegrityCheckerEnabled(true);", "hazelcast.integrity-checker.enabled to true", "-Dhz.integritychecker.enabled=true", "HZ_INTEGRITYCHECKER_ENABLED=true");
    private static final String INTEGRITY_CHECKER_IS_ENABLED = "Starting Integrity Check scan. This is a costly operation and it can be disabled if startup time is important. \nTo disable Integrity Checker do one of the following: \n" + String.format("  - Change member config using Java API: %s\n  - Change XML/YAML configuration property: Set %s\n  - Add system property: %s (for Hazelcast embedded, works only when loading config via Config.load)\n  - Add environment variable: %s (recommended when running container image. For Hazelcast embedded, works only when loading config via Config.load)", "config.setIntegrityCheckerEnabled(false);", "hazelcast.integrity-checker.enabled to false", "-Dhz.integritychecker.enabled=false", "HZ_INTEGRITYCHECKER_ENABLED=false");
    private final ILogger logger;
    private final IntegrityCheckerConfig config;

    public IntegrityChecker(IntegrityCheckerConfig config, ILogger logger) {
        this.logger = logger;
        this.config = config;
    }

    public void checkIntegrity() {
        if (!this.config.isEnabled()) {
            this.logger.info(INTEGRITY_CHECKER_IS_DISABLED);
            return;
        }
        this.logger.info(INTEGRITY_CHECKER_IS_ENABLED);
        long start = System.nanoTime();
        List<String> classNames = new ClassGraph().enableClassInfo().scan().getClassesImplementing(DataSerializerHook.class).stream().map(ClassInfo::getName).collect(Collectors.toList());
        long scanTime = (System.nanoTime() - start) / 1000000L;
        this.logger.info(String.format("Integrity Check scan finished in %d milliseconds", scanTime));
        this.checkModule(classNames);
        long totalTime = (System.nanoTime() - start) / 1000000L;
        this.logger.info(String.format("Integrity Check finished in %d milliseconds", totalTime));
    }

    private void checkModule(List<String> hooks) {
        for (String className : hooks) {
            try {
                Class<?> hookClass = this.getClassLoader().loadClass(className);
                Object hook = ServiceLoader.load(hookClass, FACTORY_ID, this.getClassLoader());
                if (hook != null) continue;
                throw new HazelcastException("Failed to instantiate DataSerializerHook class instance: " + className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new HazelcastException("Failed to verify distribution integrity, unable to load DataSerializerHook class: " + className, classNotFoundException);
            }
            catch (Exception e) {
                throw new HazelcastException(String.format("Failed to verify distribution integrity, unable to load DataSerializerHook: %s", className));
            }
        }
    }

    private ClassLoader getClassLoader() {
        return IntegrityChecker.class.getClassLoader();
    }
}

