/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.monitor.impl;

import com.hazelcast.collection.LocalCollectionStats;
import com.hazelcast.collection.LocalListStats;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.monitor.impl.AbstractLocalCollectionStats;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.ConcurrencyUtil;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class LocalListStatsImpl
extends AbstractLocalCollectionStats
implements LocalCollectionStats,
LocalListStats {
    protected static final AtomicLongFieldUpdater<LocalListStatsImpl> LAST_ACCESS_TIME_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalListStatsImpl.class, "lastAccessTime");
    protected static final AtomicLongFieldUpdater<LocalListStatsImpl> LAST_UPDATE_TIME_UPDATER = AtomicLongFieldUpdater.newUpdater(LocalListStatsImpl.class, "lastUpdateTime");
    @Probe(name="lastAccessTime", unit=ProbeUnit.MS)
    protected volatile long lastAccessTime;
    @Probe(name="lastUpdateTime", unit=ProbeUnit.MS)
    protected volatile long lastUpdateTime;
    @Probe(name="creationTime", unit=ProbeUnit.MS)
    protected final long creationTime = Clock.currentTimeMillis();

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public void setLastAccessTime(long lastAccessTime) {
        ConcurrencyUtil.setMax(this, LAST_ACCESS_TIME_UPDATER, lastAccessTime);
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public void setLastUpdateTime(long lastUpdateTime) {
        ConcurrencyUtil.setMax(this, LAST_UPDATE_TIME_UPDATER, lastUpdateTime);
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    public String toString() {
        return "LocalListStatsImpl{lastAccessTime=" + this.lastAccessTime + ", lastUpdateTime=" + this.lastUpdateTime + ", creationTime=" + this.creationTime + '}';
    }
}

