/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.MutationObserver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

class CompositeMutationObserver<R extends Record>
implements MutationObserver<R> {
    private static final int DEFAULT_OBSERVER_COUNT = 4;
    private List<MutationObserver> mutationObservers = Collections.EMPTY_LIST;

    CompositeMutationObserver() {
    }

    public void add(MutationObserver<R> mutationObserver) {
        if (this.mutationObservers == Collections.EMPTY_LIST) {
            this.mutationObservers = new ArrayList<MutationObserver>(4);
        }
        this.mutationObservers.add(mutationObserver);
    }

    @Override
    public void onClear() {
        Throwable throwable = null;
        for (int i = 0; i < this.mutationObservers.size(); ++i) {
            try {
                this.mutationObservers.get(i).onClear();
                continue;
            }
            catch (Throwable t) {
                if (throwable != null) continue;
                throwable = t;
            }
        }
        if (throwable != null) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    public void onPutRecord(Data key, R record, Object oldValue, boolean backup) {
        Throwable throwable = null;
        for (int i = 0; i < this.mutationObservers.size(); ++i) {
            try {
                this.mutationObservers.get(i).onPutRecord(key, record, oldValue, backup);
                continue;
            }
            catch (Throwable t) {
                if (throwable != null) continue;
                throwable = t;
            }
        }
        if (throwable != null) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    public void onReplicationPutRecord(@Nonnull Data key, @Nonnull R record, boolean populateIndex) {
        Throwable throwable = null;
        for (int i = 0; i < this.mutationObservers.size(); ++i) {
            try {
                this.mutationObservers.get(i).onReplicationPutRecord(key, record, populateIndex);
                continue;
            }
            catch (Throwable t) {
                if (throwable != null) continue;
                throwable = t;
            }
        }
        if (throwable != null) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    public void onUpdateRecord(@Nonnull Data key, @Nonnull R record, Object oldValue, Object newValue, boolean backup) {
        Throwable throwable = null;
        for (int i = 0; i < this.mutationObservers.size(); ++i) {
            try {
                this.mutationObservers.get(i).onUpdateRecord(key, record, oldValue, newValue, backup);
                continue;
            }
            catch (Throwable t) {
                if (throwable != null) continue;
                throwable = t;
            }
        }
        if (throwable != null) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    public void onRemoveRecord(Data key, R record) {
        Throwable throwable = null;
        for (int i = 0; i < this.mutationObservers.size(); ++i) {
            try {
                this.mutationObservers.get(i).onRemoveRecord(key, record);
                continue;
            }
            catch (Throwable t) {
                if (throwable != null) continue;
                throwable = t;
            }
        }
        if (throwable != null) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    public void onEvictRecord(Data key, R record) {
        Throwable throwable = null;
        for (int i = 0; i < this.mutationObservers.size(); ++i) {
            try {
                this.mutationObservers.get(i).onEvictRecord(key, record);
                continue;
            }
            catch (Throwable t) {
                if (throwable != null) continue;
                throwable = t;
            }
        }
        if (throwable != null) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    public void onLoadRecord(@Nonnull Data key, @Nonnull R record, boolean backup) {
        Throwable throwable = null;
        for (int i = 0; i < this.mutationObservers.size(); ++i) {
            try {
                this.mutationObservers.get(i).onLoadRecord(key, record, backup);
                continue;
            }
            catch (Throwable t) {
                if (throwable != null) continue;
                throwable = t;
            }
        }
        if (throwable != null) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    public void onDestroy(boolean isDuringShutdown, boolean internal) {
        Throwable throwable = null;
        for (int i = 0; i < this.mutationObservers.size(); ++i) {
            try {
                this.mutationObservers.get(i).onDestroy(isDuringShutdown, internal);
                continue;
            }
            catch (Throwable t) {
                if (throwable != null) continue;
                throwable = t;
            }
        }
        if (throwable != null) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    public void onReset() {
        Throwable throwable = null;
        for (int i = 0; i < this.mutationObservers.size(); ++i) {
            try {
                this.mutationObservers.get(i).onReset();
                continue;
            }
            catch (Throwable t) {
                if (throwable != null) continue;
                throwable = t;
            }
        }
        if (throwable != null) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }
}

