/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.permission;

import com.hazelcast.jet.impl.util.IOUtil;
import com.hazelcast.jet.pipeline.file.FileSourceBuilder;
import com.hazelcast.security.permission.InstancePermission;
import javax.annotation.Nullable;

public class ConnectorPermission
extends InstancePermission {
    public static final String FILE_PREFIX = "file:";
    public static final String SOCKET_PREFIX = "socket:";
    public static final String JMS_PREFIX = "jms:";
    public static final String JDBC_PREFIX = "jdbc:";
    private static final int READ = 1;
    private static final int WRITE = 2;
    private static final int ALL = 3;

    public ConnectorPermission(String name, String ... actions) {
        super(name, actions);
    }

    public static ConnectorPermission file(String directory, String action) {
        String canonicalPath = directory;
        if (!FileSourceBuilder.hasHadoopPrefix(directory)) {
            canonicalPath = IOUtil.canonicalName(directory);
        }
        return new ConnectorPermission(FILE_PREFIX + canonicalPath, action);
    }

    public static ConnectorPermission socket(String host, int port, String action) {
        return new ConnectorPermission(SOCKET_PREFIX + host + ':' + port, action);
    }

    public static ConnectorPermission jms(@Nullable String destination, String action) {
        return new ConnectorPermission(JMS_PREFIX + (destination == null ? "" : destination), action);
    }

    public static ConnectorPermission jdbc(@Nullable String connectionUrl, String action) {
        return new ConnectorPermission(JDBC_PREFIX + (connectionUrl == null ? "" : connectionUrl), action);
    }

    @Override
    protected int initMask(String[] actions) {
        int mask = 0;
        for (String action : actions) {
            if ("all".equals(action)) {
                return 3;
            }
            if ("read".equals(action)) {
                mask |= 1;
                continue;
            }
            if ("write".equals(action)) {
                mask |= 2;
                continue;
            }
            throw new IllegalArgumentException("Configured action[" + action + "] is not supported");
        }
        return mask;
    }
}

