/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.permission;

import com.hazelcast.security.permission.InstancePermission;

public class JobPermission
extends InstancePermission {
    private static final int SUBMIT = 1;
    private static final int CANCEL = 2;
    private static final int READ = 4;
    private static final int RESTART = 8;
    private static final int EXPORT_SNAPSHOT = 16;
    private static final int ADD_RESOURCES = 32;
    private static final int ALL = 63;

    public JobPermission(String ... actions) {
        super("<job>", actions);
    }

    @Override
    protected int initMask(String[] actions) {
        int mask = 4;
        for (String action : actions) {
            if ("all".equals(action)) {
                return 63;
            }
            if ("submit".equals(action)) {
                mask |= 1;
                continue;
            }
            if ("cancel".equals(action)) {
                mask |= 2;
                continue;
            }
            if ("read".equals(action)) {
                mask |= 4;
                continue;
            }
            if ("restart".equals(action)) {
                mask |= 8;
                continue;
            }
            if ("export-snapshot".equals(action)) {
                mask |= 0x10;
                continue;
            }
            if ("add-resources".equals(action)) {
                mask |= 0x20;
                continue;
            }
            throw new IllegalArgumentException("Configured action[" + action + "] is not supported");
        }
        return mask;
    }
}

