/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.aspect;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.seatunnel.app.dal.dao.IUserDao;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
@Order(value=2)
public class LogoutAspect {
    private static final Logger log = LoggerFactory.getLogger(LogoutAspect.class);
    @Resource
    private IUserDao userDaoImpl;

    @Pointcut(value="execution(public * org.apache.seatunnel.app.controller.UserController.logout(..))")
    public void logoutPointCut() {
    }

    @Before(value="logoutPointCut()")
    public void check(JoinPoint pjp) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        Integer userId = (Integer)request.getAttribute("id");
        this.userDaoImpl.disableToken(userId);
    }
}

