/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.controller;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import org.apache.seatunnel.app.common.Result;
import org.apache.seatunnel.app.dal.entity.JobDefinition;
import org.apache.seatunnel.app.domain.request.job.JobReq;
import org.apache.seatunnel.app.domain.response.PageInfo;
import org.apache.seatunnel.app.domain.response.job.JobDefinitionRes;
import org.apache.seatunnel.app.service.IJobDefinitionService;
import org.apache.seatunnel.app.service.IJobTaskService;
import org.apache.seatunnel.server.common.CodeGenerateUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/seatunnel/api/v1/job/definition"})
public class JobDefinitionController {
    @Resource
    private IJobDefinitionService jobService;
    @Resource
    private IJobTaskService jobTask;

    @PostMapping
    @ApiOperation(value="create job definition", httpMethod="POST")
    Result<Long> createJobDefinition(@ApiParam(value="userId", required=true) @RequestAttribute(value="userId") Integer userId, @RequestBody JobReq jobReq) throws CodeGenerateUtils.CodeGenerateException {
        return Result.success(this.jobService.createJob(userId, jobReq));
    }

    @GetMapping
    @ApiOperation(value="get job definition", httpMethod="GET")
    Result<PageInfo<JobDefinitionRes>> getJobDefinition(@ApiParam(value="job name") @RequestParam(required=false) String searchName, @ApiParam(value="page num", required=true) @RequestParam Integer pageNo, @ApiParam(value="page size", required=true) @RequestParam Integer pageSize, @ApiParam(value="job mode") @RequestParam(required=false) String jobMode) {
        return Result.success(this.jobService.getJob(searchName, pageNo, pageSize, jobMode));
    }

    @GetMapping(value={"/{jobId}"})
    @ApiOperation(value="get job definition", httpMethod="GET")
    Result<JobDefinition> getJobDefinition(@PathVariable long jobId) {
        return Result.success(this.jobService.getJobDefinitionByJobId(jobId));
    }

    @DeleteMapping
    @ApiOperation(value="delete job definition", httpMethod="DELETE")
    Result<Void> deleteJobDefinition(@ApiParam(value="id", required=true) @RequestParam long id) {
        this.jobService.deleteJob(id);
        this.jobTask.deleteTaskByVersionId(id);
        return Result.success();
    }
}

