/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.dal.dao.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.app.dal.dao.IVirtualTableDao;
import org.apache.seatunnel.app.dal.entity.VirtualTable;
import org.apache.seatunnel.app.dal.mapper.VirtualTableMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class VirtualTableDaoImpl
implements IVirtualTableDao {
    private static final Logger log = LoggerFactory.getLogger(VirtualTableDaoImpl.class);
    @Resource
    private VirtualTableMapper virtualTableMapper;

    @Override
    public boolean insertVirtualTable(VirtualTable virtualTable) {
        return this.virtualTableMapper.insert(virtualTable) > 0;
    }

    @Override
    public boolean updateVirtualTable(VirtualTable virtualTable) {
        return this.virtualTableMapper.updateById(virtualTable) > 0;
    }

    @Override
    public boolean deleteVirtualTable(Long id) {
        return this.virtualTableMapper.deleteById(id) > 0;
    }

    @Override
    public VirtualTable selectVirtualTableById(Long id) {
        return (VirtualTable)this.virtualTableMapper.selectById(id);
    }

    @Override
    public VirtualTable selectVirtualTableByTableName(String tableName) {
        return (VirtualTable)this.virtualTableMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"virtual_table_name", (Object)tableName));
    }

    @Override
    public boolean checkVirtualTableNameUnique(String virtualTableName, String databaseName, Long tableId) {
        return this.virtualTableMapper.checkVirtualTableNameUnique(tableId, databaseName, virtualTableName) <= 0;
    }

    @Override
    public IPage<VirtualTable> selectVirtualTablePage(Page<VirtualTable> page, String pluginName, String datasourceName) {
        log.debug("======================pluginName:{}, datasourceName:{}", (Object)pluginName, (Object)datasourceName);
        if (StringUtils.isBlank((CharSequence)pluginName) && StringUtils.isBlank((CharSequence)datasourceName)) {
            return this.virtualTableMapper.selectPage((IPage)page, (Wrapper)new QueryWrapper().orderByDesc((Object)"create_time"));
        }
        return this.virtualTableMapper.selectVirtualTablePageByParam((IPage<VirtualTable>)page, pluginName, datasourceName);
    }

    @Override
    public IPage<VirtualTable> selectDatasourceByParam(Page<VirtualTable> page, Long datasourceId) {
        return this.virtualTableMapper.selectPage((IPage)page, (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"datasource_id", (Object)datasourceId)).orderByDesc((Object)"create_time"));
    }

    @Override
    public List<String> getVirtualTableNames(String databaseName, Long datasourceId) {
        List result = this.virtualTableMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().select(new String[]{"virtual_table_name"}).eq((Object)"datasource_id", (Object)datasourceId)).eq((Object)"virtual_database_name", (Object)databaseName));
        if (CollectionUtils.isEmpty((Collection)result)) {
            return new ArrayList<String>();
        }
        return result.stream().map(VirtualTable::getVirtualTableName).collect(Collectors.toList());
    }

    @Override
    public List<String> getVirtualDatabaseNames(Long datasourceId) {
        List result = this.virtualTableMapper.selectList((Wrapper)new QueryWrapper().select(new String[]{"virtual_database_name"}).eq((Object)"datasource_id", (Object)datasourceId));
        if (CollectionUtils.isEmpty((Collection)result)) {
            return new ArrayList<String>();
        }
        return result.stream().map(VirtualTable::getVirtualDatabaseName).collect(Collectors.toList());
    }

    @Override
    public boolean checkHasVirtualTable(Long datasourceId) {
        return this.virtualTableMapper.selectCount((Wrapper)new QueryWrapper().eq((Object)"datasource_id", (Object)datasourceId)) > 0L;
    }
}

