/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.thirdparty.datasource.impl;

import com.google.auto.service.AutoService;
import java.util.Arrays;
import java.util.List;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.configuration.util.RequiredOption;
import org.apache.seatunnel.app.domain.request.connector.BusinessMode;
import org.apache.seatunnel.app.domain.request.job.DataSourceOption;
import org.apache.seatunnel.app.domain.request.job.SelectTableFields;
import org.apache.seatunnel.app.domain.response.datasource.VirtualTableDetailRes;
import org.apache.seatunnel.app.dynamicforms.FormStructure;
import org.apache.seatunnel.app.thirdparty.datasource.AbstractDataSourceConfigSwitcher;
import org.apache.seatunnel.app.thirdparty.datasource.DataSourceConfigSwitcher;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValue;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValueFactory;

@AutoService(value={DataSourceConfigSwitcher.class})
public class ElasticSearchDataSourceConfigSwitcher
extends AbstractDataSourceConfigSwitcher {
    private static final String SOURCE = "source";
    private static final String SCHEMA = "schema";
    private static final String PRIMARY_KEYS = "primary_keys";
    private static final String INDEX = "index";

    @Override
    public String getDataSourceName() {
        return "ELASTICSEARCH";
    }

    @Override
    public FormStructure filterOptionRule(String connectorName, OptionRule dataSourceOptionRule, OptionRule virtualTableOptionRule, BusinessMode businessMode, PluginType pluginType, OptionRule connectorOptionRule, List<RequiredOption> addRequiredOptions, List<Option<?>> addOptionalOptions, List<String> excludedKeys) {
        if (PluginType.SOURCE.equals((Object)pluginType)) {
            excludedKeys.addAll(Arrays.asList(SOURCE, SCHEMA, INDEX));
        } else if (PluginType.SINK.equals((Object)pluginType)) {
            excludedKeys.add(INDEX);
            if (businessMode.equals((Object)BusinessMode.DATA_REPLICA)) {
                excludedKeys.add(PRIMARY_KEYS);
            }
        } else {
            throw new UnsupportedOperationException("Unsupported plugin type: " + pluginType);
        }
        return super.filterOptionRule(connectorName, dataSourceOptionRule, virtualTableOptionRule, businessMode, pluginType, connectorOptionRule, addRequiredOptions, addOptionalOptions, excludedKeys);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Config mergeDatasourceConfig(Config dataSourceInstanceConfig, VirtualTableDetailRes virtualTableDetail, DataSourceOption dataSourceOption, SelectTableFields selectTableFields, BusinessMode businessMode, PluginType pluginType, Config connectorConfig) {
        if (PluginType.SOURCE.equals((Object)pluginType)) {
            if (!businessMode.equals((Object)BusinessMode.DATA_INTEGRATION)) throw new UnsupportedOperationException("Unsupported business mode: " + (Object)((Object)businessMode));
            connectorConfig = connectorConfig.withValue(INDEX, ConfigValueFactory.fromAnyRef((Object)dataSourceOption.getTables().get(0)));
            connectorConfig = connectorConfig.withValue(SOURCE, (ConfigValue)ConfigValueFactory.fromIterable(selectTableFields.getTableFields()));
            return super.mergeDatasourceConfig(dataSourceInstanceConfig, virtualTableDetail, dataSourceOption, selectTableFields, businessMode, pluginType, connectorConfig);
        } else {
            if (!PluginType.SINK.equals((Object)pluginType)) throw new UnsupportedOperationException("Unsupported plugin type: " + pluginType);
            if (!businessMode.equals((Object)BusinessMode.DATA_INTEGRATION)) return super.mergeDatasourceConfig(dataSourceInstanceConfig, virtualTableDetail, dataSourceOption, selectTableFields, businessMode, pluginType, connectorConfig);
            connectorConfig = connectorConfig.withValue(INDEX, ConfigValueFactory.fromAnyRef((Object)dataSourceOption.getTables().get(0)));
        }
        return super.mergeDatasourceConfig(dataSourceInstanceConfig, virtualTableDetail, dataSourceOption, selectTableFields, businessMode, pluginType, connectorConfig);
    }
}

