/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.app.domain.request.job.transform.CopyTransformOptions;
import org.apache.seatunnel.app.domain.request.job.transform.FieldMapperTransformOptions;
import org.apache.seatunnel.app.domain.request.job.transform.SQLTransformOptions;
import org.apache.seatunnel.app.domain.request.job.transform.SplitTransformOptions;
import org.apache.seatunnel.app.domain.request.job.transform.Transform;
import org.apache.seatunnel.app.domain.request.job.transform.TransformOptions;
import org.apache.seatunnel.server.common.SeatunnelErrorEnum;
import org.apache.seatunnel.server.common.SeatunnelException;

public class TaskOptionUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static <T extends TransformOptions> T getTransformOption(Transform transform, String transformOptionsStr) throws IOException {
        switch (transform) {
            case FIELDMAPPER: {
                return TaskOptionUtils.convertTransformStrToOptions(transformOptionsStr, FieldMapperTransformOptions.class);
            }
            case MULTIFIELDSPLIT: {
                return TaskOptionUtils.convertTransformStrToOptions(transformOptionsStr, SplitTransformOptions.class);
            }
            case COPY: {
                return TaskOptionUtils.convertTransformStrToOptions(transformOptionsStr, CopyTransformOptions.class);
            }
            case SQL: {
                return TaskOptionUtils.convertTransformStrToOptions(transformOptionsStr, SQLTransformOptions.class);
            }
        }
        return null;
    }

    public static <T extends TransformOptions> T convertTransformStrToOptions(String transformOptionsStr, Class<? extends TransformOptions> optionClass) throws IOException {
        if (StringUtils.isEmpty((CharSequence)transformOptionsStr)) {
            throw new SeatunnelException(SeatunnelErrorEnum.ILLEGAL_STATE, new Object[]{optionClass.getName() + " transformOptions can not be empty"});
        }
        return (T)((TransformOptions)OBJECT_MAPPER.readValue(transformOptionsStr, optionClass));
    }
}

