/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;

public class ComputeIfAbsentEntryProcessor<K, V>
implements EntryProcessor<K, V, V>,
IdentifiedDataSerializable {
    Function<? super K, ? extends V> function;

    public ComputeIfAbsentEntryProcessor() {
    }

    public ComputeIfAbsentEntryProcessor(Function<? super K, ? extends V> function) {
        this.function = function;
    }

    @Override
    public V process(Map.Entry<K, V> entry) {
        V currentValue = entry.getValue();
        if (currentValue != null) {
            return currentValue;
        }
        V newValue = this.function.apply(entry.getKey());
        if (newValue == null) {
            return null;
        }
        entry.setValue(newValue);
        return newValue;
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 149;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.function);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.function = (Function)in.readObject();
    }
}

