/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.simplify;

import java.util.List;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.simplify.ComponentJumpChecker;
import org.locationtech.jts.simplify.LineSegmentIndex;
import org.locationtech.jts.simplify.TaggedLineSegment;
import org.locationtech.jts.simplify.TaggedLineString;

public class TaggedLineStringSimplifier {
    private LineIntersector li = new RobustLineIntersector();
    private LineSegmentIndex inputIndex;
    private LineSegmentIndex outputIndex;
    private ComponentJumpChecker jumpChecker;
    private TaggedLineString line;
    private Coordinate[] linePts;

    public TaggedLineStringSimplifier(LineSegmentIndex inputIndex, LineSegmentIndex outputIndex, ComponentJumpChecker crossChecker) {
        this.inputIndex = inputIndex;
        this.outputIndex = outputIndex;
        this.jumpChecker = crossChecker;
    }

    void simplify(TaggedLineString line, double distanceTolerance) {
        this.line = line;
        this.linePts = line.getParentCoordinates();
        this.simplifySection(0, this.linePts.length - 1, 0, distanceTolerance);
        if (line.isRing() && CoordinateArrays.isRing(this.linePts)) {
            this.simplifyRingEndpoint(distanceTolerance);
        }
    }

    private void simplifySection(int i, int j, int depth, double distanceTolerance) {
        int worstCaseSize;
        ++depth;
        if (i + 1 == j) {
            TaggedLineSegment newSeg = this.line.getSegment(i);
            this.line.addToResult(newSeg);
            return;
        }
        boolean isValidToSimplify = true;
        if (this.line.getResultSize() < this.line.getMinimumSize() && (worstCaseSize = depth + 1) < this.line.getMinimumSize()) {
            isValidToSimplify = false;
        }
        double[] distance = new double[1];
        int furthestPtIndex = this.findFurthestPoint(this.linePts, i, j, distance);
        if (distance[0] > distanceTolerance) {
            isValidToSimplify = false;
        }
        if (isValidToSimplify) {
            LineSegment flatSeg = new LineSegment();
            flatSeg.p0 = this.linePts[i];
            flatSeg.p1 = this.linePts[j];
            isValidToSimplify = this.isTopologyValid(this.line, i, j, flatSeg);
        }
        if (isValidToSimplify) {
            LineSegment newSeg = this.flatten(i, j);
            this.line.addToResult(newSeg);
            return;
        }
        this.simplifySection(i, furthestPtIndex, depth, distanceTolerance);
        this.simplifySection(furthestPtIndex, j, depth, distanceTolerance);
    }

    private void simplifyRingEndpoint(double distanceTolerance) {
        if (this.line.getResultSize() > this.line.getMinimumSize()) {
            LineSegment firstSeg = this.line.getResultSegment(0);
            LineSegment lastSeg = this.line.getResultSegment(-1);
            LineSegment simpSeg = new LineSegment(lastSeg.p0, firstSeg.p1);
            Coordinate endPt = firstSeg.p0;
            if (simpSeg.distance(endPt) <= distanceTolerance && this.isTopologyValid(this.line, firstSeg, lastSeg, simpSeg)) {
                this.inputIndex.remove(firstSeg);
                this.inputIndex.remove(lastSeg);
                this.outputIndex.remove(firstSeg);
                this.outputIndex.remove(lastSeg);
                LineSegment flatSeg = this.line.removeRingEndpoint();
                this.outputIndex.add(flatSeg);
            }
        }
    }

    private int findFurthestPoint(Coordinate[] pts, int i, int j, double[] maxDistance) {
        LineSegment seg = new LineSegment();
        seg.p0 = pts[i];
        seg.p1 = pts[j];
        double maxDist = -1.0;
        int maxIndex = i;
        for (int k = i + 1; k < j; ++k) {
            Coordinate midPt = pts[k];
            double distance = seg.distance(midPt);
            if (!(distance > maxDist)) continue;
            maxDist = distance;
            maxIndex = k;
        }
        maxDistance[0] = maxDist;
        return maxIndex;
    }

    private LineSegment flatten(int start, int end) {
        Coordinate p0 = this.linePts[start];
        Coordinate p1 = this.linePts[end];
        LineSegment newSeg = new LineSegment(p0, p1);
        this.outputIndex.add(newSeg);
        this.remove(this.line, start, end);
        return newSeg;
    }

    private boolean isTopologyValid(TaggedLineString line, int sectionStart, int sectionEnd, LineSegment flatSeg) {
        if (this.hasOutputIntersection(flatSeg)) {
            return false;
        }
        if (this.hasInputIntersection(line, sectionStart, sectionEnd, flatSeg)) {
            return false;
        }
        return !this.jumpChecker.hasJump(line, sectionStart, sectionEnd, flatSeg);
    }

    private boolean isTopologyValid(TaggedLineString line, LineSegment seg1, LineSegment seg2, LineSegment flatSeg) {
        if (this.isCollinear(seg1.p0, flatSeg)) {
            return true;
        }
        if (this.hasOutputIntersection(flatSeg)) {
            return false;
        }
        if (this.hasInputIntersection(flatSeg)) {
            return false;
        }
        return !this.jumpChecker.hasJump(line, seg1, seg2, flatSeg);
    }

    private boolean isCollinear(Coordinate pt, LineSegment seg) {
        return 0 == seg.orientationIndex(pt);
    }

    private boolean hasOutputIntersection(LineSegment flatSeg) {
        List<Object> querySegs = this.outputIndex.query(flatSeg);
        for (LineSegment lineSegment : querySegs) {
            if (!this.hasInvalidIntersection(lineSegment, flatSeg)) continue;
            return true;
        }
        return false;
    }

    private boolean hasInputIntersection(LineSegment flatSeg) {
        return this.hasInputIntersection(null, -1, -1, flatSeg);
    }

    private boolean hasInputIntersection(TaggedLineString line, int excludeStart, int excludeEnd, LineSegment flatSeg) {
        List<Object> querySegs = this.inputIndex.query(flatSeg);
        for (TaggedLineSegment taggedLineSegment : querySegs) {
            if (!this.hasInvalidIntersection(taggedLineSegment, flatSeg) || line != null && TaggedLineStringSimplifier.isInLineSection(line, excludeStart, excludeEnd, taggedLineSegment)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInLineSection(TaggedLineString line, int excludeStart, int excludeEnd, TaggedLineSegment seg) {
        if (seg.getParent() != line.getParent()) {
            return false;
        }
        int segIndex = seg.getIndex();
        return excludeStart <= excludeEnd ? segIndex >= excludeStart && segIndex < excludeEnd : segIndex >= excludeStart || segIndex <= excludeEnd;
    }

    private boolean hasInvalidIntersection(LineSegment seg0, LineSegment seg1) {
        if (seg0.equalsTopo(seg1)) {
            return true;
        }
        this.li.computeIntersection(seg0.p0, seg0.p1, seg1.p0, seg1.p1);
        return this.li.isInteriorIntersection();
    }

    private void remove(TaggedLineString line, int start, int end) {
        for (int i = start; i < end; ++i) {
            TaggedLineSegment seg = line.getSegment(i);
            this.inputIndex.remove(seg);
        }
    }
}

