/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.jiffle.parser;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.sedona.shaded.antlr.tree.ParseTree;
import org.apache.sedona.shaded.jiffle.parser.AbstractModelWorker;
import org.apache.sedona.shaded.jiffle.parser.JiffleParser;
import org.apache.sedona.shaded.jiffle.parser.Symbol;
import org.apache.sedona.shaded.jiffle.parser.SymbolScope;
import org.apache.sedona.shaded.jiffle.parser.node.GetSourceValue;
import org.apache.sedona.shaded.jiffle.parser.node.Node;

public class SourcePositionsWorker
extends AbstractModelWorker {
    private final SymbolScope scope;
    private final Set<String> names;
    private final Set<GetSourceValue> positions = new HashSet<GetSourceValue>();

    public SourcePositionsWorker(ParseTree tree, List<String> sourceImageNames) {
        super(tree);
        this.names = new HashSet<String>(sourceImageNames);
        this.scope = new SymbolScope("fake", null){

            @Override
            public Symbol get(String name) {
                if (SourcePositionsWorker.this.names.contains(name)) {
                    return new Symbol(name, Symbol.Type.SOURCE_IMAGE);
                }
                return new Symbol(name, Symbol.Type.SCALAR);
            }
        };
        sourceImageNames.stream().map(name -> new Symbol((String)name, Symbol.Type.SOURCE_IMAGE)).forEach(symbol -> this.scope.add((Symbol)symbol));
        this.walkTree();
    }

    @Override
    public void exitVarID(JiffleParser.VarIDContext ctx) {
        super.exitVarID(ctx);
        Node node = (Node)this.get(ctx);
        if (node instanceof GetSourceValue) {
            this.positions.add((GetSourceValue)node);
        }
    }

    @Override
    public void exitImageCall(JiffleParser.ImageCallContext ctx) {
        super.exitImageCall(ctx);
        Node node = (Node)this.get(ctx);
        if (node instanceof GetSourceValue) {
            this.positions.add((GetSourceValue)node);
        }
    }

    @Override
    protected SymbolScope getScope(ParseTree ctx) {
        return this.scope;
    }

    public Set<GetSourceValue> getPositions() {
        return this.positions;
    }
}

