/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.jiffle.parser.node;

import java.util.Objects;
import org.apache.sedona.shaded.jiffle.parser.node.Band;
import org.apache.sedona.shaded.jiffle.parser.node.Node;
import org.apache.sedona.shaded.jiffle.parser.node.Pixel;
import org.apache.sedona.shaded.jiffle.parser.node.SourceWriter;
import org.apache.sedona.shaded.jiffle.util.Strings;

public class ImagePos
implements Node {
    public static ImagePos DEFAULT = new ImagePos(Band.DEFAULT, Pixel.DEFAULT);
    private final Band band;
    private final Pixel pixel;

    public ImagePos(Band band, Pixel pixel) {
        this.band = band;
        this.pixel = pixel;
    }

    public String toString() {
        return Strings.commas(this.pixel, this.band);
    }

    @Override
    public void write(SourceWriter w) {
        if (this.pixel != null) {
            w.append(this.pixel);
            if (this.band != null) {
                w.append(", ");
            }
        }
        if (this.band != null) {
            w.append(this.band);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImagePos imagePos = (ImagePos)o;
        return Objects.equals(this.band, imagePos.band) && Objects.equals(this.pixel, imagePos.pixel);
    }

    public int hashCode() {
        return Objects.hash(this.band, this.pixel);
    }

    public Band getBand() {
        return this.band;
    }

    public Pixel getPixel() {
        return this.pixel;
    }
}

