/*
 * Decompiled with CFR 0.152.
 */
package thredds.client.catalog;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.Service;
import thredds.client.catalog.ServiceType;
import ucar.nc2.constants.DataFormatType;

@Immutable
public class Access {
    private final Dataset dataset;
    private final String urlPath;
    private final Service service;
    private final String dataFormatS;
    private final long dataSize;

    public Access(Dataset dataset, String urlPath, Service service, String dataFormatS, long dataSize) {
        this.dataset = dataset;
        this.urlPath = urlPath;
        this.service = service;
        this.dataFormatS = dataFormatS;
        this.dataSize = dataSize;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public String getUrlPath() {
        return this.urlPath;
    }

    public Service getService() {
        return this.service;
    }

    public DataFormatType getDataFormatType() {
        if (this.dataFormatS == null) {
            return null;
        }
        try {
            return DataFormatType.getType(this.dataFormatS);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getDataFormatName() {
        return this.dataFormatS;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public String getStandardUrlName() {
        URI uri = this.getStandardUri();
        if (uri == null) {
            return null;
        }
        return uri.toString();
    }

    public URI getStandardUri() {
        try {
            Catalog cat = this.dataset.getParentCatalog();
            if (cat == null) {
                return new URI(this.getUnresolvedUrlName());
            }
            return cat.resolveUri(this.getUnresolvedUrlName());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Error parsing URL= " + this.getUnresolvedUrlName());
        }
    }

    public String getUnresolvedUrlName() {
        return this.service.getBase() + this.getUrlPath() + this.service.getSuffix();
    }

    public String getWrappedUrlName() {
        URI uri = this.getStandardUri();
        if (uri == null) {
            return null;
        }
        if (this.service.getType() == ServiceType.THREDDS) {
            return ServiceType.THREDDS.getProtocol() + ":" + uri;
        }
        if (this.service.getType() == ServiceType.CdmRemote) {
            return ServiceType.CdmRemote.getProtocol() + ":" + uri;
        }
        if (this.service.getType() == ServiceType.CdmrFeature) {
            return ServiceType.CdmrFeature.getProtocol() + ":" + uri;
        }
        return uri.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Access access = (Access)o;
        if (this.dataSize != access.dataSize) {
            return false;
        }
        if (!Objects.equals(this.dataFormatS, access.dataFormatS)) {
            return false;
        }
        if (!Objects.equals(this.service, access.service)) {
            return false;
        }
        return Objects.equals(this.urlPath, access.urlPath);
    }

    public int hashCode() {
        int result = this.urlPath != null ? this.urlPath.hashCode() : 0;
        result = 31 * result + (this.service != null ? this.service.hashCode() : 0);
        result = 31 * result + (this.dataFormatS != null ? this.dataFormatS.hashCode() : 0);
        result = 31 * result + (int)(this.dataSize ^ this.dataSize >>> 32);
        return result;
    }

    public String toString() {
        return "Access{service=" + this.service + ", urlPath='" + this.urlPath + '\'' + ", dataFormatS='" + this.dataFormatS + '\'' + ", dataSize=" + this.dataSize + '}';
    }
}

