/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.jiffle.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.sedona.shaded.antlr.ParserRuleContext;
import org.apache.sedona.shaded.antlr.Token;
import org.apache.sedona.shaded.antlr.tree.ParseTree;
import org.apache.sedona.shaded.jiffle.parser.ConstantLookup;
import org.apache.sedona.shaded.jiffle.parser.InternalCompilerException;
import org.apache.sedona.shaded.jiffle.parser.JiffleParser;
import org.apache.sedona.shaded.jiffle.parser.JiffleParserException;
import org.apache.sedona.shaded.jiffle.parser.JiffleType;
import org.apache.sedona.shaded.jiffle.parser.PropertyWorker;
import org.apache.sedona.shaded.jiffle.parser.RepeatedReadOptimizer;
import org.apache.sedona.shaded.jiffle.parser.Symbol;
import org.apache.sedona.shaded.jiffle.parser.SymbolScope;
import org.apache.sedona.shaded.jiffle.parser.node.Band;
import org.apache.sedona.shaded.jiffle.parser.node.BinaryExpression;
import org.apache.sedona.shaded.jiffle.parser.node.ConFunction;
import org.apache.sedona.shaded.jiffle.parser.node.ConstantLiteral;
import org.apache.sedona.shaded.jiffle.parser.node.DoubleLiteral;
import org.apache.sedona.shaded.jiffle.parser.node.Expression;
import org.apache.sedona.shaded.jiffle.parser.node.FunctionCall;
import org.apache.sedona.shaded.jiffle.parser.node.GetSourceValue;
import org.apache.sedona.shaded.jiffle.parser.node.ImagePos;
import org.apache.sedona.shaded.jiffle.parser.node.ImageProperty;
import org.apache.sedona.shaded.jiffle.parser.node.IntLiteral;
import org.apache.sedona.shaded.jiffle.parser.node.ListLiteral;
import org.apache.sedona.shaded.jiffle.parser.node.Node;
import org.apache.sedona.shaded.jiffle.parser.node.NodeException;
import org.apache.sedona.shaded.jiffle.parser.node.ParenExpression;
import org.apache.sedona.shaded.jiffle.parser.node.Pixel;
import org.apache.sedona.shaded.jiffle.parser.node.PostfixUnaryExpression;
import org.apache.sedona.shaded.jiffle.parser.node.PrefixUnaryExpression;
import org.apache.sedona.shaded.jiffle.parser.node.Variable;

abstract class AbstractModelWorker
extends PropertyWorker<Node> {
    protected RepeatedReadOptimizer readsOptimizer = new RepeatedReadOptimizer();

    public AbstractModelWorker(ParseTree tree) {
        super(tree);
    }

    @Override
    public void exitAtomExpr(JiffleParser.AtomExprContext ctx) {
        this.set(ctx, this.get(ctx.atom()));
    }

    @Override
    public void exitPowExpr(JiffleParser.PowExprContext ctx) {
        Expression a = this.getAsType(ctx.expression(0), Expression.class);
        Expression b = this.getAsType(ctx.expression(1), Expression.class);
        try {
            this.set(ctx, new BinaryExpression(28, a, b));
        }
        catch (NodeException ex) {
            throw new InternalCompilerException();
        }
    }

    @Override
    public void exitPostExpr(JiffleParser.PostExprContext ctx) {
        String op = ctx.getChild(1).getText();
        Expression e = this.getAsType(ctx.expression(), Expression.class);
        this.set(ctx, new PostfixUnaryExpression(e, op));
    }

    @Override
    public void exitPreExpr(JiffleParser.PreExprContext ctx) {
        String op = ctx.getChild(0).getText();
        Expression e = this.getAsType(ctx.expression(), Expression.class);
        this.set(ctx, new PrefixUnaryExpression(op, e));
    }

    @Override
    public void exitNotExpr(JiffleParser.NotExprContext ctx) {
        this.setFunctionCall(ctx, "NOT", Collections.singletonList(ctx.expression()));
    }

    @Override
    public void exitTimesDivModExpr(JiffleParser.TimesDivModExprContext ctx) {
        Expression left = this.getAsType(ctx.expression(0), Expression.class);
        Expression right = this.getAsType(ctx.expression(1), Expression.class);
        try {
            this.set(ctx, new BinaryExpression(ctx.op.getType(), left, right));
        }
        catch (NodeException ex) {
            throw new InternalCompilerException();
        }
    }

    @Override
    public void exitPlusMinusExpr(JiffleParser.PlusMinusExprContext ctx) {
        Expression left = this.getAsType(ctx.expression(0), Expression.class);
        Expression right = this.getAsType(ctx.expression(1), Expression.class);
        try {
            this.set(ctx, new BinaryExpression(ctx.op.getType(), left, right));
        }
        catch (NodeException ex) {
            throw new InternalCompilerException();
        }
    }

    @Override
    public void exitCompareExpr(JiffleParser.CompareExprContext ctx) {
        String op;
        switch (ctx.op.getType()) {
            case 38: {
                op = "LT";
                break;
            }
            case 37: {
                op = "LE";
                break;
            }
            case 36: {
                op = "GE";
                break;
            }
            case 35: {
                op = "GT";
                break;
            }
            default: {
                throw new IllegalStateException("Unknown op: " + ctx.op.getText());
            }
        }
        this.setFunctionCall(ctx, op, ctx.expression());
    }

    @Override
    public void exitEqExpr(JiffleParser.EqExprContext ctx) {
        String op;
        switch (ctx.op.getType()) {
            case 39: {
                op = "EQ";
                break;
            }
            case 40: {
                op = "NE";
                break;
            }
            default: {
                throw new IllegalStateException("Unknown op: " + ctx.op.getText());
            }
        }
        this.setFunctionCall(ctx, op, ctx.expression());
    }

    @Override
    public void exitAndExpr(JiffleParser.AndExprContext ctx) {
        this.setFunctionCall(ctx, "AND", ctx.expression());
    }

    @Override
    public void exitOrExpr(JiffleParser.OrExprContext ctx) {
        this.setFunctionCall(ctx, "OR", ctx.expression());
    }

    @Override
    public void exitXorExpr(JiffleParser.XorExprContext ctx) {
        this.setFunctionCall(ctx, "XOR", ctx.expression());
    }

    private void setFunctionCall(ParseTree ctx, String fnName, List<JiffleParser.ExpressionContext> ecs) {
        try {
            this.set(ctx, FunctionCall.of(fnName, this.asExpressions(ecs)));
        }
        catch (NodeException ex) {
            throw new InternalCompilerException();
        }
    }

    @Override
    public void exitTernaryExpr(JiffleParser.TernaryExprContext ctx) {
        Expression[] args = new Expression[]{this.getAsType(ctx.expression(0), Expression.class), this.getAsType(ctx.expression(1), Expression.class), this.getAsType(ctx.expression(2), Expression.class)};
        try {
            this.set(ctx, new ConFunction(args));
        }
        catch (NodeException ex) {
            this.messages.error(ctx.getStart(), ex.getError());
        }
    }

    @Override
    public void exitAtom(JiffleParser.AtomContext ctx) {
        this.set(ctx, this.get(ctx.getChild(0)));
    }

    @Override
    public void exitFunctionCall(JiffleParser.FunctionCallContext ctx) {
        JiffleParser.ExpressionListContext expressionList = ctx.argumentList().expressionList();
        if (expressionList == null) {
            this.setFunctionCall(ctx, ctx.start.getText(), new ArrayList<JiffleParser.ExpressionContext>());
        } else {
            this.setFunctionCall(ctx, ctx.start.getText(), expressionList.expression());
        }
    }

    @Override
    public void exitConCall(JiffleParser.ConCallContext ctx) {
        List<JiffleParser.ExpressionContext> es = ctx.argumentList().expressionList().expression();
        Expression[] args = new Expression[es.size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.getAsType(es.get(i), Expression.class);
        }
        try {
            this.set(ctx, new ConFunction(args));
        }
        catch (NodeException ex) {
            this.messages.error(ctx.getStart(), ex.getError());
        }
    }

    @Override
    public void exitParenExpression(JiffleParser.ParenExpressionContext ctx) {
        Expression e = this.getAsType(ctx.expression(), Expression.class);
        this.set(ctx, new ParenExpression(e));
    }

    @Override
    public void exitImageCall(JiffleParser.ImageCallContext ctx) {
        String name = ctx.ID().getText();
        ImagePos pos = this.getAsType(ctx.imagePos(), ImagePos.class);
        GetSourceValue node = new GetSourceValue(name, pos);
        this.readsOptimizer.add(node);
        this.set(ctx, node);
    }

    @Override
    public void exitImageProperty(JiffleParser.ImagePropertyContext ctx) {
        String varName = ctx.ID(0).getText();
        String property = ctx.ID(1).getText();
        ImageProperty node = new ImageProperty(varName, property);
        this.set(ctx, node);
    }

    @Override
    public void exitImagePos(JiffleParser.ImagePosContext ctx) {
        JiffleParser.BandSpecifierContext bandCtx = ctx.bandSpecifier();
        Band band = bandCtx == null ? Band.DEFAULT : this.getAsType(bandCtx, Band.class);
        JiffleParser.PixelSpecifierContext pixelCtx = ctx.pixelSpecifier();
        Pixel pixel = pixelCtx == null ? Pixel.DEFAULT : this.getAsType(pixelCtx, Pixel.class);
        this.set(ctx, new ImagePos(band, pixel));
    }

    @Override
    public void exitBandSpecifier(JiffleParser.BandSpecifierContext ctx) {
        Expression e = this.getAsType(ctx.expression(), Expression.class);
        this.set(ctx, new Band(e));
    }

    @Override
    public void exitPixelSpecifier(JiffleParser.PixelSpecifierContext ctx) {
        try {
            JiffleParser.PixelPosContext xpos = ctx.pixelPos(0);
            Expression e = this.getAsType(xpos.expression(), Expression.class);
            Expression x = xpos.ABS_POS_PREFIX() == null ? new BinaryExpression(32, FunctionCall.of("x", new Expression[0]), e) : e;
            JiffleParser.PixelPosContext ypos = ctx.pixelPos(1);
            e = this.getAsType(ypos.expression(), Expression.class);
            Expression y = ypos.ABS_POS_PREFIX() == null ? new BinaryExpression(32, FunctionCall.of("y", new Expression[0]), e) : e;
            this.set(ctx, new Pixel(x, y));
        }
        catch (NodeException ex) {
            throw new InternalCompilerException(ex.getError().toString());
        }
    }

    @Override
    public void exitVarID(JiffleParser.VarIDContext ctx) {
        String name = ctx.ID().getText();
        if (ConstantLookup.isDefined(name)) {
            this.set(ctx, new DoubleLiteral(Double.toString(ConstantLookup.getValue(name))));
        } else {
            Symbol symbol = this.getScope(ctx).get(name);
            switch (symbol.getType()) {
                case SOURCE_IMAGE: {
                    GetSourceValue sourceValue = new GetSourceValue(name, ImagePos.DEFAULT);
                    this.readsOptimizer.add(sourceValue);
                    this.set(ctx, sourceValue);
                    break;
                }
                case LIST: {
                    this.set(ctx, new Variable(name, JiffleType.LIST));
                    break;
                }
                case LOOP_VAR: 
                case SCALAR: {
                    this.set(ctx, new Variable(name, JiffleType.D));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Compiler error: invalid type for variable '" + name + "'");
                }
            }
        }
    }

    @Override
    public void exitLiteral(JiffleParser.LiteralContext ctx) {
        Token tok = ctx.getStart();
        switch (tok.getType()) {
            case 63: {
                this.set(ctx, new IntLiteral(tok.getText()));
                break;
            }
            case 64: {
                this.set(ctx, new DoubleLiteral(tok.getText()));
                break;
            }
            case 3: {
                this.set(ctx, ConstantLiteral.trueValue());
                break;
            }
            case 4: {
                this.set(ctx, ConstantLiteral.falseValue());
                break;
            }
            case 5: {
                this.set(ctx, ConstantLiteral.nanValue());
                break;
            }
            default: {
                throw new JiffleParserException("Unrecognized literal type: " + tok.getText());
            }
        }
    }

    @Override
    public void exitListLiteral(JiffleParser.ListLiteralContext ctx) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        if (ctx.expressionList() != null && ctx.expressionList().expression() != null) {
            for (JiffleParser.ExpressionContext ec : ctx.expressionList().expression()) {
                Expression expression = this.getAsType(ec, Expression.class);
                expressions.add(expression);
            }
        }
        this.set(ctx, new ListLiteral(expressions));
    }

    protected abstract SymbolScope getScope(ParseTree var1);

    protected <N extends Node> N getAsType(ParseTree ctx, Class<N> clazz) {
        if (this.get(ctx) == null) {
            String lineColumn = "(unknown)";
            if (ctx instanceof ParserRuleContext) {
                ParserRuleContext prc = (ParserRuleContext)ctx;
                Token start = prc.getStart();
                lineColumn = "(" + start.getLine() + ":" + start.getCharPositionInLine() + ")";
            }
            throw new IllegalStateException("Internal compiler error: no property set for node of type " + ctx.getClass().getSimpleName() + " at " + lineColumn);
        }
        try {
            return (N)((Node)clazz.cast(this.get(ctx)));
        }
        catch (ClassCastException ex) {
            String msg = String.format("Internal compiler error: cannot cast %s to %s", ((Node)this.get(ctx)).getClass().getSimpleName(), clazz.getSimpleName());
            throw new IllegalStateException(msg);
        }
    }

    protected Expression[] asExpressions(List<JiffleParser.ExpressionContext> ctxs) {
        if (ctxs == null) {
            return new Expression[0];
        }
        Expression[] exprs = new Expression[ctxs.size()];
        for (int i = 0; i < exprs.length; ++i) {
            exprs[i] = this.getAsType(ctxs.get(i), Expression.class);
        }
        return exprs;
    }
}

