/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.io.stac;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.HashMap;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.execution.datasource.stac.TemporalFilter;
import org.apache.spark.sql.execution.datasources.parquet.Covering;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetSpatialFilter;
import org.apache.spark.sql.execution.datasources.parquet.GeometryFieldMetaData;
import org.apache.spark.sql.sedona_sql.io.stac.StacBatch$;
import org.apache.spark.sql.sedona_sql.io.stac.StacPartition;
import org.apache.spark.sql.sedona_sql.io.stac.StacPartitionReader;
import org.apache.spark.sql.sedona_sql.io.stac.StacUtils$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.json4s.JsonAST;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple8;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Growable;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0005\r5a\u0001B\u001f?\u00016C\u0001\u0002\u001d\u0001\u0003\u0016\u0004%\t!\u001d\u0005\t}\u0002\u0011\t\u0012)A\u0005e\"Iq\u0010\u0001BK\u0002\u0013\u0005\u0011\u0011\u0001\u0005\u000b\u0003'\u0001!\u0011#Q\u0001\n\u0005\r\u0001BCA\u000b\u0001\tU\r\u0011\"\u0001\u0002\u0002!Q\u0011q\u0003\u0001\u0003\u0012\u0003\u0006I!a\u0001\t\u0015\u0005e\u0001A!f\u0001\n\u0003\tY\u0002\u0003\u0006\u0002*\u0001\u0011\t\u0012)A\u0005\u0003;A!\"a\u000b\u0001\u0005+\u0007I\u0011AA\u0017\u0011)\t)\u0004\u0001B\tB\u0003%\u0011q\u0006\u0005\u000b\u0003o\u0001!Q3A\u0005\u0002\u0005e\u0002BCA+\u0001\tE\t\u0015!\u0003\u0002<!Q\u0011q\u000b\u0001\u0003\u0016\u0004%\t!!\u0017\t\u0015\u0005-\u0004A!E!\u0002\u0013\tY\u0006\u0003\u0006\u0002n\u0001\u0011)\u001a!C\u0001\u0003_B!\"!\u001f\u0001\u0005#\u0005\u000b\u0011BA9\u0011\u001d\tY\b\u0001C\u0001\u0003{B\u0011\"a%\u0001\u0005\u0004%I!!&\t\u0011\u0005]\u0005\u0001)A\u0005\u0003gB\u0011\"!'\u0001\u0005\u0004%I!!&\t\u0011\u0005m\u0005\u0001)A\u0005\u0003gB\u0011\"!(\u0001\u0001\u0004%I!!&\t\u0013\u0005}\u0005\u00011A\u0005\n\u0005\u0005\u0006\u0002CAW\u0001\u0001\u0006K!a\u001d\t\u0013\u0005=\u0006\u00011A\u0005\n\u0005U\u0005\"CAY\u0001\u0001\u0007I\u0011BAZ\u0011!\t9\f\u0001Q!\n\u0005M\u0004\"CA]\u0001\t\u0007I\u0011AA^\u0011!\t)\u000e\u0001Q\u0001\n\u0005u\u0006bBAl\u0001\u0011\u0005\u0011\u0011\u001c\u0005\b\u0003?\u0004A\u0011IAq\u0011\u001d\ty\u000f\u0001C\u0001\u0003cDqA!\u0007\u0001\t\u0003\u0011Y\u0002C\u0004\u0003(\u0001!\tA!\u000b\t\u000f\tE\u0002\u0001\"\u0011\u00034!I!1\b\u0001\u0002\u0002\u0013\u0005!Q\b\u0005\n\u0005\u001f\u0002\u0011\u0013!C\u0001\u0005#B\u0011Ba\u001a\u0001#\u0003%\tA!\u001b\t\u0013\t5\u0004!%A\u0005\u0002\t%\u0004\"\u0003B8\u0001E\u0005I\u0011\u0001B9\u0011%\u0011)\bAI\u0001\n\u0003\u00119\bC\u0005\u0003|\u0001\t\n\u0011\"\u0001\u0003~!I!\u0011\u0011\u0001\u0012\u0002\u0013\u0005!1\u0011\u0005\n\u0005\u000f\u0003\u0011\u0013!C\u0001\u0005\u0013C\u0011B!$\u0001\u0003\u0003%\tEa$\t\u0013\tU\u0005!!A\u0005\u0002\u0005U\u0005\"\u0003BL\u0001\u0005\u0005I\u0011\u0001BM\u0011%\u0011\u0019\u000bAA\u0001\n\u0003\u0012)\u000bC\u0005\u00030\u0002\t\t\u0011\"\u0001\u00032\"I!Q\u0017\u0001\u0002\u0002\u0013\u0005#q\u0017\u0005\n\u0005w\u0003\u0011\u0011!C!\u0005{C\u0011Ba0\u0001\u0003\u0003%\tE!1\t\u0013\t\r\u0007!!A\u0005B\t\u0015w!\u0003Be}\u0005\u0005\t\u0012\u0001Bf\r!id(!A\t\u0002\t5\u0007bBA>o\u0011\u0005!1\u001d\u0005\n\u0005\u007f;\u0014\u0011!C#\u0005\u0003D\u0011B!:8\u0003\u0003%\tIa:\t\u0013\tex'!A\u0005\u0002\nm\b\"CB\u0005o\u0005\u0005I\u0011BB\u0006\u0005%\u0019F/Y2CCR\u001c\u0007N\u0003\u0002@\u0001\u0006!1\u000f^1d\u0015\t\t%)\u0001\u0002j_*\u00111\tR\u0001\u000bg\u0016$wN\\1`gFd'BA#G\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000f\"\u000bQa\u001d9be.T!!\u0013&\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0015aA8sO\u000e\u00011#\u0002\u0001O-z#\u0007CA(U\u001b\u0005\u0001&BA)S\u0003\u0011a\u0017M\\4\u000b\u0003M\u000bAA[1wC&\u0011Q\u000b\u0015\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005]cV\"\u0001-\u000b\u0005eS\u0016\u0001\u0002:fC\u0012T!a\u0017#\u0002\u0013\r|gN\\3di>\u0014\u0018BA/Y\u0005\u0015\u0011\u0015\r^2i!\ty&-D\u0001a\u0015\u0005\t\u0017!B:dC2\f\u0017BA2a\u0005\u001d\u0001&o\u001c3vGR\u0004\"!Z7\u000f\u0005\u0019\\gBA4k\u001b\u0005A'BA5M\u0003\u0019a$o\\8u}%\t\u0011-\u0003\u0002mA\u00069\u0001/Y2lC\u001e,\u0017B\u00018p\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\ta\u0007-A\u0007ce>\fGmY1ti\u000e{gNZ\u000b\u0002eB\u00191O\u001e=\u000e\u0003QT!!\u001e$\u0002\u0013\t\u0014x.\u00193dCN$\u0018BA<u\u0005%\u0011%o\\1eG\u0006\u001cH\u000f\u0005\u0002zy6\t!P\u0003\u0002|\r\u0006!Q\u000f^5m\u0013\ti(PA\rTKJL\u0017\r\\5{C\ndWmQ8oM&<WO]1uS>t\u0017A\u00042s_\u0006$7-Y:u\u0007>tg\rI\u0001\u0012gR\f7mQ8mY\u0016\u001cG/[8o+JdWCAA\u0002!\u0011\t)!!\u0004\u000f\t\u0005\u001d\u0011\u0011\u0002\t\u0003O\u0002L1!a\u0003a\u0003\u0019\u0001&/\u001a3fM&!\u0011qBA\t\u0005\u0019\u0019FO]5oO*\u0019\u00111\u00021\u0002%M$\u0018mY\"pY2,7\r^5p]V\u0013H\u000eI\u0001\u0013gR\f7mQ8mY\u0016\u001cG/[8o\u0015N|g.A\nti\u0006\u001c7i\u001c7mK\u000e$\u0018n\u001c8Kg>t\u0007%\u0001\u0004tG\",W.Y\u000b\u0003\u0003;\u0001B!a\b\u0002&5\u0011\u0011\u0011\u0005\u0006\u0004\u0003G!\u0015!\u0002;za\u0016\u001c\u0018\u0002BA\u0014\u0003C\u0011!b\u0015;sk\u000e$H+\u001f9f\u0003\u001d\u00198\r[3nC\u0002\nAa\u001c9ugV\u0011\u0011q\u0006\t\t\u0003\u000b\t\t$a\u0001\u0002\u0004%!\u00111GA\t\u0005\ri\u0015\r]\u0001\u0006_B$8\u000fI\u0001\u000egB\fG/[1m\r&dG/\u001a:\u0016\u0005\u0005m\u0002#B0\u0002>\u0005\u0005\u0013bAA A\n1q\n\u001d;j_:\u0004B!a\u0011\u0002R5\u0011\u0011Q\t\u0006\u0005\u0003\u000f\nI%A\u0004qCJ\fX/\u001a;\u000b\t\u0005-\u0013QJ\u0001\fI\u0006$\u0018m]8ve\u000e,7OC\u0002\u0002P\u0011\u000b\u0011\"\u001a=fGV$\u0018n\u001c8\n\t\u0005M\u0013Q\t\u0002\u0018\u000f\u0016|\u0007+\u0019:rk\u0016$8\u000b]1uS\u0006dg)\u001b7uKJ\fab\u001d9bi&\fGNR5mi\u0016\u0014\b%\u0001\buK6\u0004xN]1m\r&dG/\u001a:\u0016\u0005\u0005m\u0003#B0\u0002>\u0005u\u0003\u0003BA0\u0003Oj!!!\u0019\u000b\u0007}\n\u0019G\u0003\u0003\u0002f\u00055\u0013A\u00033bi\u0006\u001cx.\u001e:dK&!\u0011\u0011NA1\u00059!V-\u001c9pe\u0006dg)\u001b7uKJ\fq\u0002^3na>\u0014\u0018\r\u001c$jYR,'\u000fI\u0001\fY&l\u0017\u000e\u001e$jYR,'/\u0006\u0002\u0002rA)q,!\u0010\u0002tA\u0019q,!\u001e\n\u0007\u0005]\u0004MA\u0002J]R\fA\u0002\\5nSR4\u0015\u000e\u001c;fe\u0002\na\u0001P5oSRtDCEA@\u0003\u0007\u000b))a\"\u0002\n\u0006-\u0015QRAH\u0003#\u00032!!!\u0001\u001b\u0005q\u0004\"\u00029\u0012\u0001\u0004\u0011\bBB@\u0012\u0001\u0004\t\u0019\u0001C\u0004\u0002\u0016E\u0001\r!a\u0001\t\u000f\u0005e\u0011\u00031\u0001\u0002\u001e!9\u00111F\tA\u0002\u0005=\u0002bBA\u001c#\u0001\u0007\u00111\b\u0005\b\u0003/\n\u0002\u0019AA.\u0011\u001d\ti'\u0005a\u0001\u0003c\n1\u0004Z3gCVdG/\u0013;f[Nd\u0015.\\5u!\u0016\u0014(+Z9vKN$XCAA:\u0003q!WMZ1vYRLE/Z7t\u0019&l\u0017\u000e\u001e)feJ+\u0017/^3ti\u0002\nq$\u001b;f[Ndu.\u00193Qe>\u001cWm]:SKB|'\u000f\u001e+ie\u0016\u001c\bn\u001c7e\u0003\u0001JG/Z7t\u0019>\fG\r\u0015:pG\u0016\u001c8OU3q_J$H\u000b\u001b:fg\"|G\u000e\u001a\u0011\u0002\u0017%$X-\\'bq2+g\r^\u0001\u0010SR,W.T1y\u0019\u00164Go\u0018\u0013fcR!\u00111UAU!\ry\u0016QU\u0005\u0004\u0003O\u0003'\u0001B+oSRD\u0011\"a+\u0018\u0003\u0003\u0005\r!a\u001d\u0002\u0007a$\u0013'\u0001\u0007ji\u0016lW*\u0019=MK\u001a$\b%A\bmCN$(+\u001a9peR\u001cu.\u001e8u\u0003Ma\u0017m\u001d;SKB|'\u000f^\"pk:$x\fJ3r)\u0011\t\u0019+!.\t\u0013\u0005-&$!AA\u0002\u0005M\u0014\u0001\u00057bgR\u0014V\r]8si\u000e{WO\u001c;!\u0003\u0019i\u0017\r\u001d9feV\u0011\u0011Q\u0018\t\u0005\u0003\u007f\u000b\t.\u0004\u0002\u0002B*!\u00111YAc\u0003!!\u0017\r^1cS:$'\u0002BAd\u0003\u0013\fqA[1dWN|gN\u0003\u0003\u0002L\u00065\u0017!\u00034bgR,'\u000f_7m\u0015\t\ty-A\u0002d_6LA!a5\u0002B\naqJ\u00196fGRl\u0015\r\u001d9fe\u00069Q.\u00199qKJ\u0004\u0013AD:fi&#X-\\'bq2+g\r\u001e\u000b\u0005\u0003G\u000bY\u000eC\u0004\u0002^z\u0001\r!a\u001d\u0002\u000bY\fG.^3\u0002'Ad\u0017M\\%oaV$\b+\u0019:uSRLwN\\:\u0015\u0005\u0005\r\b#B0\u0002f\u0006%\u0018bAAtA\n)\u0011I\u001d:bsB\u0019q+a;\n\u0007\u00055\bL\u0001\bJ]B,H\u000fU1si&$\u0018n\u001c8\u0002!\r|G\u000e\\3di&#X-\u001c'j].\u001cHCCAR\u0003g\f90a?\u0003\u0010!9\u0011Q\u001f\u0011A\u0002\u0005\r\u0011AE2pY2,7\r^5p]\n\u000b7/\u001a)bi\"Dq!!?!\u0001\u0004\t\u0019!\u0001\bd_2dWm\u0019;j_:T5o\u001c8\t\u000f\u0005u\b\u00051\u0001\u0002\u0000\u0006I\u0011\u000e^3n\u0019&t7n\u001d\t\u0007\u0005\u0003\u0011Y!a\u0001\u000e\u0005\t\r!\u0002\u0002B\u0003\u0005\u000f\tq!\\;uC\ndWMC\u0002\u0003\n\u0001\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011iAa\u0001\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\u0005\b\u0005#\u0001\u0003\u0019\u0001B\n\u0003IqW-\u001a3D_VtGOT3yi&#X-\\:\u0011\u0007}\u0013)\"C\u0002\u0003\u0018\u0001\u0014qAQ8pY\u0016\fg.A\u0006hKRLE/Z7MS:\\GCCA\u0002\u0005;\u0011\tCa\t\u0003&!9!qD\u0011A\u0002\u0005\r\u0011aB5uK6,&\u000f\u001c\u0005\b\u0003'\u000b\u0003\u0019AA:\u0011\u001d\t9$\ta\u0001\u0003wAq!a\u0016\"\u0001\u0004\tY&\u0001\tgS2$XM]\"pY2,7\r^5p]RA!1\u0003B\u0016\u0005[\u0011y\u0003C\u0004\u0002z\n\u0002\r!a\u0001\t\u000f\u0005]\"\u00051\u0001\u0002<!9\u0011q\u000b\u0012A\u0002\u0005m\u0013aE2sK\u0006$XMU3bI\u0016\u0014h)Y2u_JLHC\u0001B\u001b!\r9&qG\u0005\u0004\u0005sA&A\u0006)beRLG/[8o%\u0016\fG-\u001a:GC\u000e$xN]=\u0002\t\r|\u0007/\u001f\u000b\u0013\u0003\u007f\u0012yD!\u0011\u0003D\t\u0015#q\tB%\u0005\u0017\u0012i\u0005C\u0004qIA\u0005\t\u0019\u0001:\t\u0011}$\u0003\u0013!a\u0001\u0003\u0007A\u0011\"!\u0006%!\u0003\u0005\r!a\u0001\t\u0013\u0005eA\u0005%AA\u0002\u0005u\u0001\"CA\u0016IA\u0005\t\u0019AA\u0018\u0011%\t9\u0004\nI\u0001\u0002\u0004\tY\u0004C\u0005\u0002X\u0011\u0002\n\u00111\u0001\u0002\\!I\u0011Q\u000e\u0013\u0011\u0002\u0003\u0007\u0011\u0011O\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011\u0019FK\u0002s\u0005+Z#Aa\u0016\u0011\t\te#1M\u0007\u0003\u00057RAA!\u0018\u0003`\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005C\u0002\u0017AC1o]>$\u0018\r^5p]&!!Q\rB.\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011YG\u000b\u0003\u0002\u0004\tU\u0013AD2paf$C-\u001a4bk2$HeM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011\u0019H\u000b\u0003\u0002\u001e\tU\u0013AD2paf$C-\u001a4bk2$H%N\u000b\u0003\u0005sRC!a\f\u0003V\u0005q1m\u001c9zI\u0011,g-Y;mi\u00122TC\u0001B@U\u0011\tYD!\u0016\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%oU\u0011!Q\u0011\u0016\u0005\u00037\u0012)&\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001d\u0016\u0005\t-%\u0006BA9\u0005+\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001BI!\ry%1S\u0005\u0004\u0003\u001f\u0001\u0016\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u00057\u0013\t\u000bE\u0002`\u0005;K1Aa(a\u0005\r\te.\u001f\u0005\n\u0003W{\u0013\u0011!a\u0001\u0003g\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005O\u0003bA!+\u0003,\nmUB\u0001B\u0004\u0013\u0011\u0011iKa\u0002\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005'\u0011\u0019\fC\u0005\u0002,F\n\t\u00111\u0001\u0003\u001c\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u0011\tJ!/\t\u0013\u0005-&'!AA\u0002\u0005M\u0014\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005M\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\tE\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0003\u0014\t\u001d\u0007\"CAVk\u0005\u0005\t\u0019\u0001BN\u0003%\u0019F/Y2CCR\u001c\u0007\u000eE\u0002\u0002\u0002^\u001aRa\u000eBh\u00057\u0004RC!5\u0003XJ\f\u0019!a\u0001\u0002\u001e\u0005=\u00121HA.\u0003c\ny(\u0004\u0002\u0003T*\u0019!Q\u001b1\u0002\u000fI,h\u000e^5nK&!!\u0011\u001cBj\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000f\t\u0005\u0005;\u0014\t/\u0004\u0002\u0003`*\u0011\u0011IU\u0005\u0004]\n}GC\u0001Bf\u0003\u0015\t\u0007\u000f\u001d7z)I\tyH!;\u0003l\n5(q\u001eBy\u0005g\u0014)Pa>\t\u000bAT\u0004\u0019\u0001:\t\r}T\u0004\u0019AA\u0002\u0011\u001d\t)B\u000fa\u0001\u0003\u0007Aq!!\u0007;\u0001\u0004\ti\u0002C\u0004\u0002,i\u0002\r!a\f\t\u000f\u0005]\"\b1\u0001\u0002<!9\u0011q\u000b\u001eA\u0002\u0005m\u0003bBA7u\u0001\u0007\u0011\u0011O\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011ip!\u0002\u0011\u000b}\u000biDa@\u0011%}\u001b\tA]A\u0002\u0003\u0007\ti\"a\f\u0002<\u0005m\u0013\u0011O\u0005\u0004\u0007\u0007\u0001'A\u0002+va2,\u0007\bC\u0005\u0004\bm\n\t\u00111\u0001\u0002\u0000\u0005\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u00039\u0003")
public class StacBatch
implements Batch,
Product,
Serializable {
    private final Broadcast<SerializableConfiguration> broadcastConf;
    private final String stacCollectionUrl;
    private final String stacCollectionJson;
    private final StructType schema;
    private final Map<String, String> opts;
    private final Option<GeoParquetSpatialFilter> spatialFilter;
    private final Option<TemporalFilter> temporalFilter;
    private final Option<Object> limitFilter;
    private final int defaultItemsLimitPerRequest;
    private final int itemsLoadProcessReportThreshold;
    private int itemMaxLeft;
    private int lastReportCount;
    private final ObjectMapper mapper;

    public static Option<Tuple8<Broadcast<SerializableConfiguration>, String, String, StructType, Map<String, String>, Option<GeoParquetSpatialFilter>, Option<TemporalFilter>, Option<Object>>> unapply(StacBatch x$0) {
        return StacBatch$.MODULE$.unapply(x$0);
    }

    public static StacBatch apply(Broadcast<SerializableConfiguration> broadcastConf, String stacCollectionUrl, String stacCollectionJson, StructType schema, Map<String, String> opts, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter, Option<Object> limitFilter) {
        return StacBatch$.MODULE$.apply(broadcastConf, stacCollectionUrl, stacCollectionJson, schema, opts, spatialFilter, temporalFilter, limitFilter);
    }

    public static Function1<Tuple8<Broadcast<SerializableConfiguration>, String, String, StructType, Map<String, String>, Option<GeoParquetSpatialFilter>, Option<TemporalFilter>, Option<Object>>, StacBatch> tupled() {
        return StacBatch$.MODULE$.tupled();
    }

    public static Function1<Broadcast<SerializableConfiguration>, Function1<String, Function1<String, Function1<StructType, Function1<Map<String, String>, Function1<Option<GeoParquetSpatialFilter>, Function1<Option<TemporalFilter>, Function1<Option<Object>, StacBatch>>>>>>>> curried() {
        return StacBatch$.MODULE$.curried();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public Broadcast<SerializableConfiguration> broadcastConf() {
        return this.broadcastConf;
    }

    public String stacCollectionUrl() {
        return this.stacCollectionUrl;
    }

    public String stacCollectionJson() {
        return this.stacCollectionJson;
    }

    public StructType schema() {
        return this.schema;
    }

    public Map<String, String> opts() {
        return this.opts;
    }

    public Option<GeoParquetSpatialFilter> spatialFilter() {
        return this.spatialFilter;
    }

    public Option<TemporalFilter> temporalFilter() {
        return this.temporalFilter;
    }

    public Option<Object> limitFilter() {
        return this.limitFilter;
    }

    private int defaultItemsLimitPerRequest() {
        return this.defaultItemsLimitPerRequest;
    }

    private int itemsLoadProcessReportThreshold() {
        return this.itemsLoadProcessReportThreshold;
    }

    private int itemMaxLeft() {
        return this.itemMaxLeft;
    }

    private void itemMaxLeft_$eq(int x$1) {
        this.itemMaxLeft = x$1;
    }

    private int lastReportCount() {
        return this.lastReportCount;
    }

    private void lastReportCount_$eq(int x$1) {
        this.lastReportCount = x$1;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public void setItemMaxLeft(int value) {
        this.itemMaxLeft_$eq(value);
    }

    public InputPartition[] planInputPartitions() {
        Some some;
        int limit;
        String stacCollectionBasePath = StacUtils$.MODULE$.getStacCollectionBasePath(this.stacCollectionUrl());
        ArrayBuffer itemLinks = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Option<Object> option = this.limitFilter();
        int itemsLimitMax = option instanceof Some && (limit = BoxesRunTime.unboxToInt((Object)(some = (Some)option).value())) >= 0 ? limit : StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)this.opts().getOrElse((Object)"itemsLimitMax", (Function0 & Serializable)() -> "-1")));
        boolean checkItemsLimitMax = itemsLimitMax > 0;
        this.setItemMaxLeft(itemsLimitMax);
        this.collectItemLinks(stacCollectionBasePath, this.stacCollectionJson(), (ArrayBuffer<String>)itemLinks, checkItemsLimitMax);
        if (itemLinks.isEmpty()) {
            return (InputPartition[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(InputPartition.class));
        }
        int numPartitions = StacUtils$.MODULE$.getNumPartitions(itemLinks.length(), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)this.opts().getOrElse((Object)"numPartitions", (Function0 & Serializable)() -> "-1"))), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)this.opts().getOrElse((Object)"maxPartitionItemFiles", (Function0 & Serializable)() -> "-1"))), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)this.opts().getOrElse((Object)"defaultParallelism", (Function0 & Serializable)() -> "1"))));
        if (itemLinks.length() < numPartitions) {
            return (InputPartition[])((IterableOnceOps)((StrictOptimizedIterableOps)itemLinks.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String item = (String)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    return new StacPartition(index, (String[])((Object[])new String[]{item}), new HashMap<String, String>());
                }
                throw new MatchError((Object)tuple2);
            })).toArray(ClassTag$.MODULE$.apply(InputPartition.class));
        }
        int partitionSize = (int)Math.ceil((double)itemLinks.length() / (double)numPartitions);
        return (InputPartition[])((IterableOps)Random$.MODULE$.shuffle((IterableOnce)itemLinks, BuildFrom$.MODULE$.buildFromIterableOps())).grouped(partitionSize).zipWithIndex().map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                ArrayBuffer items = (ArrayBuffer)tuple2._1();
                int index = tuple2._2$mcI$sp();
                return new StacPartition(index, (String[])items.toArray(ClassTag$.MODULE$.apply(String.class)), new HashMap<String, String>());
            }
            throw new MatchError((Object)tuple2);
        }).toArray(ClassTag$.MODULE$.apply(InputPartition.class));
    }

    public void collectItemLinks(String collectionBasePath, String collectionJson, ArrayBuffer<String> itemLinks, boolean needCountNextItems) {
        if (needCountNextItems && this.itemMaxLeft() <= 0) {
            return;
        }
        if (itemLinks.size() - this.lastReportCount() >= this.itemsLoadProcessReportThreshold()) {
            Console$.MODULE$.out().println(new StringBuilder(38).append("Searched or partitioned ").append(itemLinks.size()).append(" items so far.").toString());
            this.lastReportCount_$eq(itemLinks.size());
        }
        JsonNode rootNode = this.mapper().readTree(collectionJson);
        JsonNode linksNode = rootNode.get("links");
        java.util.Iterator iterator = linksNode.elements();
        while (iterator.hasNext()) {
            String href;
            String rel;
            block9: {
                block8: {
                    JsonNode linkNode = (JsonNode)iterator.next();
                    rel = linkNode.get("rel").asText();
                    href = linkNode.get("href").asText();
                    String string = rel;
                    String string2 = "item";
                    if (!(string == null ? string2 != null : !string.equals(string2))) break block8;
                    String string3 = rel;
                    String string4 = "items";
                    if (string3 != null ? !string3.equals(string4) : string4 != null) break block9;
                }
                String itemUrl = href.startsWith("http") || href.startsWith("file") ? href : new StringBuilder(0).append(collectionBasePath).append(href).toString();
                String string = rel;
                String string5 = "items";
                Growable growable = !(string != null ? !string.equals(string5) : string5 != null) && href.startsWith("http") ? itemLinks.$plus$eq((Object)new StringBuilder(7).append(itemUrl).append("?limit=").append(this.defaultItemsLimitPerRequest()).toString()) : itemLinks.$plus$eq((Object)itemUrl);
                if (needCountNextItems && this.itemMaxLeft() <= 0) {
                    return;
                }
                String string6 = rel;
                String string7 = "item";
                if (!(string6 != null ? !string6.equals(string7) : string7 != null) && needCountNextItems) {
                    this.itemMaxLeft_$eq(this.itemMaxLeft() - 1);
                    continue;
                }
                String string8 = rel;
                String string9 = "items";
                if (string8 != null ? !string8.equals(string9) : string9 != null) continue;
                if (!href.startsWith("http") || !this.iterateItemsWithLimit$1(this.getItemLink(itemUrl, this.defaultItemsLimitPerRequest(), this.spatialFilter(), this.temporalFilter()), needCountNextItems, collectionBasePath, itemLinks)) continue;
                return;
            }
            String string = rel;
            String string10 = "child";
            if (string != null ? !string.equals(string10) : string10 != null) continue;
            String childUrl = href.startsWith("http") || href.startsWith("file") ? href : new StringBuilder(0).append(collectionBasePath).append(href).toString();
            String linkedCollectionJson = StacUtils$.MODULE$.loadStacCollectionToJson(childUrl, StacUtils$.MODULE$.loadStacCollectionToJson$default$2());
            String nestedCollectionBasePath = StacUtils$.MODULE$.getStacCollectionBasePath(childUrl);
            boolean collectionFiltered = this.filterCollection(linkedCollectionJson, this.spatialFilter(), this.temporalFilter());
            if (collectionFiltered) continue;
            this.collectItemLinks(nestedCollectionBasePath, linkedCollectionJson, itemLinks, needCountNextItems);
        }
    }

    public String getItemLink(String itemUrl, int defaultItemsLimitPerRequest, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter) {
        String baseUrl = new StringBuilder(7).append(itemUrl).append("?limit=").append(defaultItemsLimitPerRequest).toString();
        String urlWithFilters = StacUtils$.MODULE$.addFiltersToUrl(baseUrl, spatialFilter, temporalFilter);
        return urlWithFilters;
    }

    public boolean filterCollection(String collectionJson, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter) {
        boolean bl;
        boolean bl2;
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(collectionJson);
        Option<GeoParquetSpatialFilter> option = spatialFilter;
        if (option instanceof Some) {
            List bbox;
            Some some = (Some)option;
            GeoParquetSpatialFilter filter = (GeoParquetSpatialFilter)some.value();
            JsonNode extentNode = rootNode.path("extent").path("spatial").path("bbox");
            bl2 = extentNode.isMissingNode() ? false : !(bbox = CollectionConverters$.MODULE$.IteratorHasAsScala(extentNode.elements()).asScala().map((Function1 & Serializable)bboxNode -> {
                double minX = bboxNode.get(0).asDouble();
                double minY = bboxNode.get(1).asDouble();
                double maxX = bboxNode.get(2).asDouble();
                double maxY = bboxNode.get(3).asDouble();
                return new Tuple4((Object)BoxesRunTime.boxToDouble((double)minX), (Object)BoxesRunTime.boxToDouble((double)minY), (Object)BoxesRunTime.boxToDouble((double)maxX), (Object)BoxesRunTime.boxToDouble((double)maxY));
            }).toList()).exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)StacBatch.$anonfun$filterCollection$2(filter, x0$1)));
        } else if (None$.MODULE$.equals(option)) {
            bl2 = false;
        } else {
            throw new MatchError(option);
        }
        boolean spatialFiltered = bl2;
        Option<TemporalFilter> option2 = temporalFilter;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            TemporalFilter filter = (TemporalFilter)some.value();
            JsonNode extentNode = rootNode.path("extent").path("temporal").path("interval");
            if (extentNode.isMissingNode()) {
                bl = true;
            } else {
                DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").optionalStart().appendFraction(ChronoField.MILLI_OF_SECOND, 0, 3, true).optionalEnd().appendPattern("'Z'").toFormatter();
                List intervals = CollectionConverters$.MODULE$.IteratorHasAsScala(extentNode.elements()).asScala().map((Function1 & Serializable)intervalNode -> {
                    LocalDateTime start = LocalDateTime.parse(intervalNode.get(0).asText(), formatter);
                    LocalDateTime end = LocalDateTime.parse(intervalNode.get(1).asText(), formatter);
                    return new Tuple2((Object)start, (Object)end);
                }).toList();
                bl = !intervals.exists((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)StacBatch.$anonfun$filterCollection$4(filter, x0$2)));
            }
        } else if (None$.MODULE$.equals(option2)) {
            bl = false;
        } else {
            throw new MatchError(option2);
        }
        boolean temporalFiltered = bl;
        return spatialFiltered || temporalFiltered;
    }

    public PartitionReaderFactory createReaderFactory() {
        return (PartitionReaderFactory & Serializable)partition -> new StacPartitionReader(this.broadcastConf(), (StacPartition)partition, this.schema(), this.opts(), this.spatialFilter(), this.temporalFilter());
    }

    public StacBatch copy(Broadcast<SerializableConfiguration> broadcastConf, String stacCollectionUrl, String stacCollectionJson, StructType schema, Map<String, String> opts, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter, Option<Object> limitFilter) {
        return new StacBatch(broadcastConf, stacCollectionUrl, stacCollectionJson, schema, opts, spatialFilter, temporalFilter, limitFilter);
    }

    public Broadcast<SerializableConfiguration> copy$default$1() {
        return this.broadcastConf();
    }

    public String copy$default$2() {
        return this.stacCollectionUrl();
    }

    public String copy$default$3() {
        return this.stacCollectionJson();
    }

    public StructType copy$default$4() {
        return this.schema();
    }

    public Map<String, String> copy$default$5() {
        return this.opts();
    }

    public Option<GeoParquetSpatialFilter> copy$default$6() {
        return this.spatialFilter();
    }

    public Option<TemporalFilter> copy$default$7() {
        return this.temporalFilter();
    }

    public Option<Object> copy$default$8() {
        return this.limitFilter();
    }

    public String productPrefix() {
        return "StacBatch";
    }

    public int productArity() {
        return 8;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.broadcastConf();
            }
            case 1: {
                return this.stacCollectionUrl();
            }
            case 2: {
                return this.stacCollectionJson();
            }
            case 3: {
                return this.schema();
            }
            case 4: {
                return this.opts();
            }
            case 5: {
                return this.spatialFilter();
            }
            case 6: {
                return this.temporalFilter();
            }
            case 7: {
                return this.limitFilter();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StacBatch;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "broadcastConf";
            }
            case 1: {
                return "stacCollectionUrl";
            }
            case 2: {
                return "stacCollectionJson";
            }
            case 3: {
                return "schema";
            }
            case 4: {
                return "opts";
            }
            case 5: {
                return "spatialFilter";
            }
            case 6: {
                return "temporalFilter";
            }
            case 7: {
                return "limitFilter";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StacBatch)) return false;
        boolean bl = true;
        if (!bl) return false;
        StacBatch stacBatch = (StacBatch)x$1;
        Broadcast<SerializableConfiguration> broadcast = this.broadcastConf();
        Broadcast<SerializableConfiguration> broadcast2 = stacBatch.broadcastConf();
        if (broadcast == null) {
            if (broadcast2 != null) {
                return false;
            }
        } else if (!broadcast.equals(broadcast2)) return false;
        String string = this.stacCollectionUrl();
        String string2 = stacBatch.stacCollectionUrl();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.stacCollectionJson();
        String string4 = stacBatch.stacCollectionJson();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        StructType structType = this.schema();
        StructType structType2 = stacBatch.schema();
        if (structType == null) {
            if (structType2 != null) {
                return false;
            }
        } else if (!structType.equals(structType2)) return false;
        Map<String, String> map = this.opts();
        Map<String, String> map2 = stacBatch.opts();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Option<GeoParquetSpatialFilter> option = this.spatialFilter();
        Option<GeoParquetSpatialFilter> option2 = stacBatch.spatialFilter();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<TemporalFilter> option3 = this.temporalFilter();
        Option<TemporalFilter> option4 = stacBatch.temporalFilter();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<Object> option5 = this.limitFilter();
        Option<Object> option6 = stacBatch.limitFilter();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        if (!stacBatch.canEqual(this)) return false;
        return true;
    }

    private final boolean iterateItemsWithLimit$1(String itemUrl, boolean needCountNextItems, String collectionBasePath$1, ArrayBuffer itemLinks$1) {
        boolean bl;
        Object object = new Object();
        try {
            ObjectRef nextUrl = ObjectRef.create((Object)new Some((Object)itemUrl));
            Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                while (((Option)nextUrl$1.elem).isDefined()) {
                    String itemJson = StacUtils$.MODULE$.loadStacCollectionToJson((String)((Option)nextUrl$1.elem).get(), StacUtils$.MODULE$.loadStacCollectionToJson$default$2());
                    JsonNode itemRootNode = this.mapper().readTree(itemJson);
                    JsonNode itemLinksNode = itemRootNode.get("links");
                    if (itemLinksNode == null) {
                        throw new NonLocalReturnControl.mcZ.sp(object, true);
                    }
                    java.util.Iterator itemIterator = itemLinksNode.elements();
                    nextUrl$1.elem = None$.MODULE$;
                    while (itemIterator.hasNext()) {
                        JsonNode itemLinkNode = (JsonNode)itemIterator.next();
                        String itemRel = itemLinkNode.get("rel").asText();
                        String itemHref = itemLinkNode.get("href").asText();
                        String string = itemRel;
                        String string2 = "next";
                        if (string != null ? !string.equals(string2) : string2 != null) continue;
                        JsonNode numberReturnedNode = itemRootNode.get("numberReturned");
                        int numberReturned = numberReturnedNode == null ? this.defaultItemsLimitPerRequest() : numberReturnedNode.asInt();
                        this.itemMaxLeft_$eq(this.itemMaxLeft() - numberReturned);
                        if (needCountNextItems && this.itemMaxLeft() <= 0) {
                            throw new NonLocalReturnControl.mcZ.sp(object, true);
                        }
                        nextUrl$1.elem = new Some((Object)(itemHref.startsWith("http") || itemHref.startsWith("file") ? itemHref : new StringBuilder(0).append(collectionBasePath$1).append(itemHref).toString()));
                    }
                    Object object = ((Option)nextUrl$1.elem).isDefined() ? itemLinks$1.$plus$eq(((Option)nextUrl$1.elem).get()) : BoxedUnit.UNIT;
                }
            });
            bl = false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$filterCollection$2(GeoParquetSpatialFilter filter$1, Tuple4 x0$1) {
        Tuple4 tuple4 = x0$1;
        if (tuple4 != null) {
            double minX = BoxesRunTime.unboxToDouble((Object)tuple4._1());
            double minY = BoxesRunTime.unboxToDouble((Object)tuple4._2());
            double maxX = BoxesRunTime.unboxToDouble((Object)tuple4._3());
            double maxY = BoxesRunTime.unboxToDouble((Object)tuple4._4());
            .colon.colon geometryTypes = new .colon.colon((Object)"Polygon", (List)Nil$.MODULE$);
            Seq bbox = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{minX, minY, maxX, maxY}));
            GeometryFieldMetaData geometryFieldMetaData = new GeometryFieldMetaData("WKB", (Seq<String>)geometryTypes, (Seq<Object>)bbox, (Option<JsonAST.JValue>)None$.MODULE$, (Option<Covering>)None$.MODULE$);
            return filter$1.evaluate((Map<String, GeometryFieldMetaData>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"geometry"), (Object)geometryFieldMetaData)}))));
        }
        throw new MatchError((Object)tuple4);
    }

    public static final /* synthetic */ boolean $anonfun$filterCollection$4(TemporalFilter filter$2, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            LocalDateTime start = (LocalDateTime)tuple2._1();
            LocalDateTime end = (LocalDateTime)tuple2._2();
            return filter$2.evaluate((Map<String, LocalDateTime>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datetime"), (Object)start)})))) || filter$2.evaluate((Map<String, LocalDateTime>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"datetime"), (Object)end)}))));
        }
        throw new MatchError((Object)tuple2);
    }

    public StacBatch(Broadcast<SerializableConfiguration> broadcastConf, String stacCollectionUrl, String stacCollectionJson, StructType schema, Map<String, String> opts, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter, Option<Object> limitFilter) {
        this.broadcastConf = broadcastConf;
        this.stacCollectionUrl = stacCollectionUrl;
        this.stacCollectionJson = stacCollectionJson;
        this.schema = schema;
        this.opts = opts;
        this.spatialFilter = spatialFilter;
        this.temporalFilter = temporalFilter;
        this.limitFilter = limitFilter;
        Product.$init$((Product)this);
        int itemsLimitMax = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)"itemsLimitMax", (Function0 & Serializable)() -> "-1")));
        int limitPerRequest = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)"itemsLimitPerRequest", (Function0 & Serializable)() -> "10")));
        this.defaultItemsLimitPerRequest = itemsLimitMax > 0 && limitPerRequest > itemsLimitMax ? itemsLimitMax : limitPerRequest;
        this.itemsLoadProcessReportThreshold = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)opts.getOrElse((Object)"itemsLoadProcessReportThreshold", (Function0 & Serializable)() -> "1000000")));
        this.itemMaxLeft = -1;
        this.lastReportCount = 0;
        this.mapper = new ObjectMapper();
    }
}

