/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.raster.serde;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class KryoUtil {
    private KryoUtil() {
    }

    public static void writeObjectWithLength(Kryo kryo, Output output, Object object) {
        int lengthOffset = output.position();
        output.writeInt(0);
        int start = output.position();
        kryo.writeObject(output, object);
        int end = output.position();
        int length = end - start;
        output.setPosition(lengthOffset);
        output.writeInt(length);
        output.setPosition(end);
    }

    public static void writeUTF8String(Output output, String value) {
        byte[] utf8 = value.getBytes(StandardCharsets.UTF_8);
        output.writeInt(utf8.length);
        output.writeBytes(utf8);
    }

    public static String readUTF8String(Input input) {
        int length = input.readInt();
        byte[] utf8 = new byte[length];
        input.readBytes(utf8);
        return new String(utf8, StandardCharsets.UTF_8);
    }

    public static void writeIntArray(Output output, int[] array) {
        output.writeInt(array.length);
        output.writeInts(array);
    }

    public static int[] readIntArray(Input input) {
        int length = input.readInt();
        return input.readInts(length);
    }

    public static void writeIntArrays(Output output, int[][] arrays) {
        output.writeInt(arrays.length);
        for (int[] array : arrays) {
            KryoUtil.writeIntArray(output, array);
        }
    }

    public static int[][] readIntArrays(Input input) {
        int length = input.readInt();
        int[][] arrays = new int[length][];
        for (int i = 0; i < length; ++i) {
            arrays[i] = KryoUtil.readIntArray(input);
        }
        return arrays;
    }

    public static void writeByteArrays(Output output, byte[][] arrays) {
        output.writeInt(arrays.length);
        for (byte[] array : arrays) {
            output.writeInt(array.length);
            output.writeBytes(array);
        }
    }

    public static byte[][] readByteArrays(Input input) {
        int length = input.readInt();
        byte[][] arrays = new byte[length][];
        for (int i = 0; i < length; ++i) {
            int arrayLength = input.readInt();
            arrays[i] = input.readBytes(arrayLength);
        }
        return arrays;
    }

    public static void writeDoubleArrays(Output output, double[][] arrays) {
        output.writeInt(arrays.length);
        for (double[] array : arrays) {
            output.writeInt(array.length);
            output.writeDoubles(array);
        }
    }

    public static double[][] readDoubleArrays(Input input) {
        int length = input.readInt();
        double[][] arrays = new double[length][];
        for (int i = 0; i < length; ++i) {
            int arrayLength = input.readInt();
            arrays[i] = input.readDoubles(arrayLength);
        }
        return arrays;
    }

    public static void writeLongArrays(Output output, long[][] arrays) {
        output.writeInt(arrays.length);
        for (long[] array : arrays) {
            output.writeInt(array.length);
            output.writeLongs(array);
        }
    }

    public static long[][] readLongArrays(Input input) {
        int length = input.readInt();
        long[][] arrays = new long[length][];
        for (int i = 0; i < length; ++i) {
            int arrayLength = input.readInt();
            arrays[i] = input.readLongs(arrayLength);
        }
        return arrays;
    }

    public static void writeFloatArrays(Output output, float[][] arrays) {
        output.writeInt(arrays.length);
        for (float[] array : arrays) {
            output.writeInt(array.length);
            output.writeFloats(array);
        }
    }

    public static float[][] readFloatArrays(Input input) {
        int length = input.readInt();
        float[][] arrays = new float[length][];
        for (int i = 0; i < length; ++i) {
            int arrayLength = input.readInt();
            arrays[i] = input.readFloats(arrayLength);
        }
        return arrays;
    }

    public static void writeShortArrays(Output output, short[][] arrays) {
        output.writeInt(arrays.length);
        for (short[] array : arrays) {
            output.writeInt(array.length);
            output.writeShorts(array);
        }
    }

    public static short[][] readShortArrays(Input input) {
        int length = input.readInt();
        short[][] arrays = new short[length][];
        for (int i = 0; i < length; ++i) {
            int arrayLength = input.readInt();
            arrays[i] = input.readShorts(arrayLength);
        }
        return arrays;
    }

    public static void writeUTF8StringMap(Output output, Map<String, String> map) {
        if (map == null) {
            output.writeInt(-1);
            return;
        }
        output.writeInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            KryoUtil.writeUTF8String(output, entry.getKey());
            KryoUtil.writeUTF8String(output, entry.getValue());
        }
    }

    public static Map<String, String> readUTF8StringMap(Input input) {
        int size = input.readInt();
        if (size == -1) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>(size);
        for (int i = 0; i < size; ++i) {
            String key = KryoUtil.readUTF8String(input);
            String value = KryoUtil.readUTF8String(input);
            params.put(key, value);
        }
        return params;
    }
}

