/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.config.properties.DashboardProperties;
import org.apache.shenyu.admin.mapper.PermissionMapper;
import org.apache.shenyu.admin.mapper.ResourceMapper;
import org.apache.shenyu.admin.model.custom.UserInfo;
import org.apache.shenyu.admin.model.dto.PermissionDTO;
import org.apache.shenyu.admin.model.entity.PermissionDO;
import org.apache.shenyu.admin.model.event.resource.BatchResourceCreatedEvent;
import org.apache.shenyu.admin.model.event.resource.BatchResourceDeletedEvent;
import org.apache.shenyu.admin.model.event.resource.ResourceCreatedEvent;
import org.apache.shenyu.admin.model.event.role.BatchRoleDeletedEvent;
import org.apache.shenyu.admin.model.event.role.RoleUpdatedEvent;
import org.apache.shenyu.admin.model.query.PermissionQuery;
import org.apache.shenyu.admin.model.vo.NamespacePluginVO;
import org.apache.shenyu.admin.model.vo.PermissionMenuVO;
import org.apache.shenyu.admin.model.vo.PluginVO;
import org.apache.shenyu.admin.model.vo.ResourceVO;
import org.apache.shenyu.admin.service.NamespacePluginService;
import org.apache.shenyu.admin.service.PermissionService;
import org.apache.shenyu.admin.utils.JwtUtils;
import org.apache.shenyu.admin.utils.ResourceUtil;
import org.apache.shenyu.admin.utils.SessionUtil;
import org.apache.shenyu.common.constant.ResourceTypeConstants;
import org.apache.shenyu.common.utils.ListUtil;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
public class PermissionServiceImpl
implements PermissionService {
    private final PermissionMapper permissionMapper;
    private final ResourceMapper resourceMapper;
    private final DashboardProperties dashboardProperties;
    private final NamespacePluginService namespacePluginService;

    public PermissionServiceImpl(PermissionMapper permissionMapper, ResourceMapper resourceMapper, DashboardProperties dashboardProperties, NamespacePluginService namespacePluginService) {
        this.permissionMapper = permissionMapper;
        this.resourceMapper = resourceMapper;
        this.dashboardProperties = dashboardProperties;
        this.namespacePluginService = namespacePluginService;
    }

    @Override
    public PermissionMenuVO getPermissionMenu(String namespaceId) {
        List<NamespacePluginVO> pluginList;
        UserInfo userInfo = JwtUtils.getUserInfo();
        if (Objects.isNull(userInfo)) {
            return null;
        }
        String selectedNamespaceId = namespaceId;
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            selectedNamespaceId = "649330b6-c2d7-4edc-be8e-8a54df9eb385";
        }
        if (CollectionUtils.isEmpty(pluginList = this.namespacePluginService.listByNamespaceId(selectedNamespaceId))) {
            List<ResourceVO> resourceVOList = this.getResourceListByUserNameAndPluginNames(userInfo.getUserName(), Collections.emptySet());
            if (CollectionUtils.isEmpty(resourceVOList)) {
                return null;
            }
            return new PermissionMenuVO(ResourceUtil.buildMenu(resourceVOList), this.getAuthPerm(resourceVOList), this.getAllAuthPerms());
        }
        Set<String> pluginNameSet = pluginList.stream().map(PluginVO::getName).collect(Collectors.toSet());
        List<ResourceVO> resourceVOList = this.getResourceListByUserNameAndPluginNames(userInfo.getUserName(), pluginNameSet);
        if (CollectionUtils.isEmpty(resourceVOList)) {
            return null;
        }
        return new PermissionMenuVO(ResourceUtil.buildMenu(resourceVOList), this.getAuthPerm(resourceVOList), this.getAllAuthPerms());
    }

    @Override
    public Set<String> getAuthPermByUserName(String userName) {
        List<ResourceVO> resourceVOList = this.getResourceListByUserName(userName);
        if (CollectionUtils.isNotEmpty(resourceVOList)) {
            return this.getAuthPerm(resourceVOList).stream().map(PermissionMenuVO.AuthPerm::getPerms).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @EventListener(value={ResourceCreatedEvent.class})
    public void onResourcesCreated(ResourceCreatedEvent event) {
        this.permissionMapper.insertSelective(this.buildPermissionFromResourceId(event.getResource().getId()));
    }

    @EventListener(value={BatchResourceCreatedEvent.class})
    public void onResourcesCreated(BatchResourceCreatedEvent event) {
        this.permissionMapper.insertBatch(ListUtil.map(event.getDeletedIds(), this::buildPermissionFromResourceId));
    }

    @EventListener(value={BatchResourceDeletedEvent.class})
    public void onResourcesCreated(BatchResourceDeletedEvent event) {
        this.permissionMapper.deleteByResourceId(event.getDeletedIds());
    }

    @EventListener(value={BatchRoleDeletedEvent.class})
    public void onRoleDeleted(BatchRoleDeletedEvent event) {
        this.permissionMapper.deleteByObjectIds(event.getDeletedIds());
    }

    @EventListener(value={RoleUpdatedEvent.class})
    public void onRoleUpdated(RoleUpdatedEvent event) {
        this.manageRolePermission(event.getRole().getId(), event.getNewPermission());
    }

    private List<ResourceVO> getResourceListByUserName(String userName) {
        if (SessionUtil.isAdmin()) {
            return ListUtil.map(this.resourceMapper.selectByUserName(userName), ResourceVO::buildResourceVO);
        }
        return this.resourceMapper.selectByUserName(userName).stream().filter(r -> !this.dashboardProperties.getOnlySuperAdminPermission().contains(r.getPerms())).map(ResourceVO::buildResourceVO).collect(Collectors.toList());
    }

    private List<ResourceVO> getResourceListByUserNameAndPluginNames(String userName, Collection<String> pluginNames) {
        if (SessionUtil.isAdmin()) {
            return ListUtil.map(this.resourceMapper.selectByUserName(userName), ResourceVO::buildResourceVO);
        }
        return this.resourceMapper.selectByUserName(userName).stream().filter(r -> !this.dashboardProperties.getOnlySuperAdminPermission().contains(r.getPerms())).filter(r -> {
            String url = r.getUrl();
            if (StringUtils.isBlank((CharSequence)url)) {
                return true;
            }
            if (url.contains("/plug/")) {
                return pluginNames.contains(url.replaceFirst("/plug/", ""));
            }
            return true;
        }).map(ResourceVO::buildResourceVO).collect(Collectors.toList());
    }

    private PermissionDO buildPermissionFromResourceId(String resourceId) {
        return PermissionDO.buildPermissionDO(PermissionDTO.builder().objectId("1346358560427216896").resourceId(resourceId).build());
    }

    private List<PermissionMenuVO.AuthPerm> getAuthPerm(List<ResourceVO> resourceVOList) {
        return resourceVOList.stream().filter(item -> item.getResourceType().equals(ResourceTypeConstants.MENU_TYPE_2)).map(PermissionMenuVO.AuthPerm::buildAuthPerm).collect(Collectors.toList());
    }

    private List<PermissionMenuVO.AuthPerm> getAllAuthPerms() {
        return this.resourceMapper.selectByResourceType(ResourceTypeConstants.MENU_TYPE_2).stream().map(item -> PermissionMenuVO.AuthPerm.buildAuthPerm(ResourceVO.buildResourceVO(item))).collect(Collectors.toList());
    }

    private void manageRolePermission(String roleId, List<String> currentPermissionList) {
        List<String> deletePermission;
        List<String> lastPermissionList = this.permissionMapper.findByObjectId(roleId).stream().map(PermissionDO::getResourceId).collect(Collectors.toList());
        List<String> addPermission = this.getListDiff(lastPermissionList, currentPermissionList);
        if (CollectionUtils.isNotEmpty(addPermission)) {
            this.batchSavePermission(addPermission.stream().map(node -> PermissionDO.buildPermissionDO(PermissionDTO.builder().objectId(roleId).resourceId((String)node).build())).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty(deletePermission = this.getListDiff(currentPermissionList, lastPermissionList))) {
            deletePermission.forEach(node -> this.deleteByObjectIdAndResourceId(new PermissionQuery(roleId, (String)node)));
        }
    }

    private List<String> getListDiff(List<String> preList, List<String> lastList) {
        if (CollectionUtils.isEmpty(lastList)) {
            return Collections.emptyList();
        }
        if (CollectionUtils.isEmpty(preList)) {
            return lastList;
        }
        Map map = preList.stream().distinct().collect(Collectors.toMap(Function.identity(), source -> 1));
        return lastList.stream().filter(item -> !map.containsKey(item)).collect(Collectors.toList());
    }

    private void batchSavePermission(List<PermissionDO> permissionDOList) {
        permissionDOList.forEach(this.permissionMapper::insertSelective);
    }

    private void deleteByObjectIdAndResourceId(PermissionQuery permissionQuery) {
        this.permissionMapper.deleteByObjectIdAndResourceId(permissionQuery);
    }
}

