/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.alert.strategy;

import jakarta.mail.internet.MimeMessage;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import org.apache.shenyu.alert.AlertNotifyHandler;
import org.apache.shenyu.alert.exception.AlertNoticeException;
import org.apache.shenyu.alert.model.AlertReceiverDTO;
import org.apache.shenyu.common.dto.AlarmContent;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;

@Component
final class EmailAlertNotifyStrategy
implements AlertNotifyHandler {
    private final JavaMailSender javaMailSender;
    private final TemplateEngine templateEngine;
    @Value(value="${spring.mail.username}")
    private String emailFromUser;

    EmailAlertNotifyStrategy(TemplateEngine templateEngine, JavaMailSender javaMailSender) {
        this.javaMailSender = javaMailSender;
        this.templateEngine = templateEngine;
    }

    @Override
    public void send(AlertReceiverDTO receiver, AlarmContent alert) throws AlertNoticeException {
        try {
            MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
            MimeMessageHelper messageHelper = new MimeMessageHelper(mimeMessage, true, "UTF-8");
            messageHelper.setSubject("ShenYu Alarm");
            messageHelper.setFrom(this.emailFromUser);
            messageHelper.setTo(receiver.getEmail());
            messageHelper.setSentDate(new Date());
            String process = this.buildAlertHtmlTemplate(alert);
            messageHelper.setText(process, true);
            this.javaMailSender.send(mimeMessage);
        }
        catch (Exception e) {
            throw new AlertNoticeException("[Email Notify Error] " + e.getMessage());
        }
    }

    private String buildAlertHtmlTemplate(AlarmContent alert) {
        Context context = new Context();
        context.setVariable("nameTitle", (Object)"ShenYu Alarm");
        context.setVariable("nameTriggerTime", (Object)"Alarm Time");
        context.setVariable("nameContent", (Object)"Alarm Content");
        context.setVariable("content", (Object)alert.getContent());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date alertTime = alert.getDateCreated();
        if (Objects.isNull(alert)) {
            alertTime = new Date();
        }
        String alarmTime = simpleDateFormat.format(alertTime);
        context.setVariable("lastTriggerTime", (Object)alarmTime);
        return this.templateEngine.process("mailAlarm", (IContext)context);
    }

    @Override
    public byte type() {
        return 1;
    }
}

