/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.api.exception.runtime;

import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import java.lang.reflect.Type;

public class NacosDeserializationException
extends NacosRuntimeException {
    private static final long serialVersionUID = -2742350751684273728L;
    private static final String DEFAULT_MSG = "Nacos deserialize failed. ";
    private static final String MSG_FOR_SPECIFIED_CLASS = "Nacos deserialize for class [%s] failed. ";
    private static final String ERROR_MSG_FOR_SPECIFIED_CLASS = "Nacos deserialize for class [%s] failed, cause error[%s]. ";
    private Class<?> targetClass;

    public NacosDeserializationException() {
        super(101);
    }

    public NacosDeserializationException(Class<?> targetClass) {
        super(101, String.format(MSG_FOR_SPECIFIED_CLASS, targetClass.getName()));
        this.targetClass = targetClass;
    }

    public NacosDeserializationException(Type targetType) {
        super(101, String.format(MSG_FOR_SPECIFIED_CLASS, targetType.toString()));
    }

    public NacosDeserializationException(Throwable throwable) {
        super(101, DEFAULT_MSG, throwable);
    }

    public NacosDeserializationException(Class<?> targetClass, Throwable throwable) {
        super(101, String.format(ERROR_MSG_FOR_SPECIFIED_CLASS, targetClass.getName(), throwable.getMessage()), throwable);
        this.targetClass = targetClass;
    }

    public NacosDeserializationException(Type targetType, Throwable throwable) {
        super(101, String.format(ERROR_MSG_FOR_SPECIFIED_CLASS, targetType.toString(), throwable.getMessage()), throwable);
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }
}

