/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.impl;

import com.alibaba.nacos.client.config.utils.ConcurrentDiskUtil;
import com.alibaba.nacos.client.config.utils.JvmUtil;
import com.alibaba.nacos.client.config.utils.SnapShotSwitch;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.client.utils.ParamUtil;
import com.alibaba.nacos.common.utils.IoUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.slf4j.Logger;

public class LocalConfigInfoProcessor {
    private static final Logger LOGGER = LogUtils.logger(LocalConfigInfoProcessor.class);
    public static final String LOCAL_SNAPSHOT_PATH = NacosClientProperties.PROTOTYPE.getProperty("JM.SNAPSHOT.PATH", NacosClientProperties.PROTOTYPE.getProperty("user.home")) + File.separator + "nacos" + File.separator + "config";
    private static final String SUFFIX = "_nacos";
    private static final String ENV_CHILD = "snapshot";
    private static final String FAILOVER_FILE_CHILD_1 = "data";
    private static final String FAILOVER_FILE_CHILD_2 = "config-data";
    private static final String FAILOVER_FILE_CHILD_3 = "config-data-tenant";
    private static final String SNAPSHOT_FILE_CHILD_1 = "snapshot";
    private static final String SNAPSHOT_FILE_CHILD_2 = "snapshot-tenant";

    public static String getFailover(String serverName, String dataId, String group, String tenant) {
        File localPath = LocalConfigInfoProcessor.getFailoverFile(serverName, dataId, group, tenant);
        if (!localPath.exists() || !localPath.isFile()) {
            return null;
        }
        try {
            return LocalConfigInfoProcessor.readFile(localPath);
        }
        catch (IOException ioe) {
            LOGGER.error("[" + serverName + "] get failover error, " + localPath, (Throwable)ioe);
            return null;
        }
    }

    public static String getSnapshot(String name, String dataId, String group, String tenant) {
        if (!SnapShotSwitch.getIsSnapShot().booleanValue()) {
            return null;
        }
        File file = LocalConfigInfoProcessor.getSnapshotFile(name, dataId, group, tenant);
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        try {
            return LocalConfigInfoProcessor.readFile(file);
        }
        catch (IOException ioe) {
            LOGGER.error("[" + name + "]+get snapshot error, " + file, (Throwable)ioe);
            return null;
        }
    }

    protected static String readFile(File file) throws IOException {
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        if (JvmUtil.isMultiInstance().booleanValue()) {
            return ConcurrentDiskUtil.getFileContent(file, "UTF-8");
        }
        try (FileInputStream is = new FileInputStream(file);){
            String string = IoUtils.toString(is, "UTF-8");
            return string;
        }
    }

    public static void saveSnapshot(String envName, String dataId, String group, String tenant, String config) {
        if (!SnapShotSwitch.getIsSnapShot().booleanValue()) {
            return;
        }
        File file = LocalConfigInfoProcessor.getSnapshotFile(envName, dataId, group, tenant);
        if (null == config) {
            try {
                IoUtils.delete(file);
            }
            catch (IOException ioe) {
                LOGGER.error("[" + envName + "] delete snapshot error, " + file, (Throwable)ioe);
            }
        } else {
            try {
                boolean isMdOk;
                File parentFile = file.getParentFile();
                if (!parentFile.exists() && !(isMdOk = parentFile.mkdirs())) {
                    LOGGER.error("[{}] save snapshot error", (Object)envName);
                }
                if (JvmUtil.isMultiInstance().booleanValue()) {
                    ConcurrentDiskUtil.writeFileContent(file, config, "UTF-8");
                } else {
                    IoUtils.writeStringToFile(file, config, "UTF-8");
                }
            }
            catch (IOException ioe) {
                LOGGER.error("[" + envName + "] save snapshot error, " + file, (Throwable)ioe);
            }
        }
    }

    public static void cleanAllSnapshot() {
        try {
            File rootFile = new File(LOCAL_SNAPSHOT_PATH);
            File[] files = rootFile.listFiles();
            if (files == null || files.length == 0) {
                return;
            }
            for (File file : files) {
                if (!file.getName().endsWith(SUFFIX)) continue;
                IoUtils.cleanDirectory(file);
            }
        }
        catch (IOException ioe) {
            LOGGER.error("clean all snapshot error, " + ioe.toString(), (Throwable)ioe);
        }
    }

    public static void cleanEnvSnapshot(String envName) {
        File tmp = new File(LOCAL_SNAPSHOT_PATH, envName + SUFFIX);
        tmp = new File(tmp, "snapshot");
        try {
            IoUtils.cleanDirectory(tmp);
            LOGGER.info("success delete {}-snapshot", (Object)envName);
        }
        catch (IOException e) {
            LOGGER.warn("fail delete {}-snapshot, exception: ", (Object)envName, (Object)e);
        }
    }

    static File getFailoverFile(String serverName, String dataId, String group, String tenant) {
        serverName = ParamUtil.simplyEnvNameIfOverLimit(serverName);
        File tmp = new File(LOCAL_SNAPSHOT_PATH, serverName + SUFFIX);
        tmp = new File(tmp, FAILOVER_FILE_CHILD_1);
        if (StringUtils.isBlank(tenant)) {
            tmp = new File(tmp, FAILOVER_FILE_CHILD_2);
        } else {
            tmp = new File(tmp, FAILOVER_FILE_CHILD_3);
            tmp = new File(tmp, tenant);
        }
        return new File(new File(tmp, group), dataId);
    }

    static File getSnapshotFile(String envName, String dataId, String group, String tenant) {
        envName = ParamUtil.simplyEnvNameIfOverLimit(envName);
        File tmp = new File(LOCAL_SNAPSHOT_PATH, envName + SUFFIX);
        if (StringUtils.isBlank(tenant)) {
            tmp = new File(tmp, "snapshot");
        } else {
            tmp = new File(tmp, SNAPSHOT_FILE_CHILD_2);
            tmp = new File(tmp, tenant);
        }
        return new File(new File(tmp, group), dataId);
    }

    static {
        LOGGER.info("LOCAL_SNAPSHOT_PATH:{}", (Object)LOCAL_SNAPSHOT_PATH);
    }
}

