/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client;

import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.client.AbstractCluster;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.ext.Extension;

@Extension(value="failfast")
public class FailFastCluster
extends AbstractCluster {
    public FailFastCluster(ConsumerBootstrap consumerBootstrap) {
        super(consumerBootstrap);
    }

    @Override
    public SofaResponse doInvoke(SofaRequest request) throws SofaRpcException {
        ProviderInfo providerInfo = this.select(request);
        try {
            SofaResponse response = this.filterChain(providerInfo, request);
            if (response != null) {
                return response;
            }
            throw new SofaRpcException(299, "Failed to call " + request.getInterfaceName() + "." + request.getMethodName() + " on remote server " + providerInfo + ", return null");
        }
        catch (Exception e) {
            throw new SofaRpcException(299, "Failed to call " + request.getInterfaceName() + "." + request.getMethodName() + " on remote server: " + providerInfo + ", cause by: " + e.getClass().getName() + ", message is: " + e.getMessage(), e);
        }
    }
}

