/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.kubernetes;

import com.alipay.sofa.rpc.client.ProviderHelper;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.AbstractInterfaceConfig;
import com.alipay.sofa.rpc.config.ConfigUniqueNameGenerator;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.registry.utils.RegistryUtils;
import io.fabric8.kubernetes.api.model.Pod;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class KubernetesRegistryHelper
extends RegistryUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubernetesRegistryHelper.class);

    public static List<ProviderInfo> convertPodsToProviders(List<Pod> pods, ConsumerConfig config) {
        ArrayList<ProviderInfo> providerInfos = new ArrayList<ProviderInfo>();
        if (CommonUtils.isEmpty(pods) || null == config) {
            return providerInfos;
        }
        for (Pod pod : pods) {
            ProviderInfo providerInfo = KubernetesRegistryHelper.getProviderInfo(pod, config);
            if (null == providerInfo) continue;
            providerInfos.add(providerInfo);
        }
        return providerInfos;
    }

    public static String convertToUrl(Pod pod, ServerConfig serverConfig, ProviderConfig providerConfig) {
        String uri = "";
        String protocol = serverConfig.getProtocol();
        if (StringUtils.isNotEmpty(protocol)) {
            uri = protocol + "://";
        }
        uri = uri + pod.getStatus().getPodIP() + ":" + serverConfig.getPort();
        Map<String, String> metaData = RegistryUtils.convertProviderToMap(providerConfig, serverConfig);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : metaData.entrySet()) {
            sb.append("&").append(entry.getKey()).append("=").append(entry.getValue());
        }
        if (sb.length() > 0) {
            uri = uri + sb.replace(0, 1, "?").toString();
        }
        return uri;
    }

    private static ProviderInfo getProviderInfo(Pod pod, ConsumerConfig config) {
        try {
            String dataId = KubernetesRegistryHelper.buildDataId(config, config.getProtocol());
            String providerUrlString = (String)pod.getMetadata().getAnnotations().get(dataId);
            if (StringUtils.isBlank(providerUrlString)) {
                return null;
            }
            return ProviderHelper.toProviderInfo(providerUrlString);
        }
        catch (Exception e) {
            LOGGER.info("get provider config error with pod");
            return null;
        }
    }

    public static String buildDataId(AbstractInterfaceConfig config, String protocol) {
        if ("bolt".equals(protocol) || "tr".equals(protocol)) {
            return ConfigUniqueNameGenerator.getUniqueName(config) + "@DEFAULT";
        }
        return ConfigUniqueNameGenerator.getUniqueName(config) + "@" + protocol;
    }
}

