/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.kubernetes.utils;

import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.RegistryConfig;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import java.util.Base64;

public class KubernetesConfigUtils {
    public static Config buildKubernetesConfig(RegistryConfig registryConfig) {
        Config base = Config.autoConfigure(null);
        return ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder(base).withMasterUrl(KubernetesConfigUtils.buildMasterUrl(registryConfig))).withApiVersion(registryConfig.getParameter("apiVersion", base.getApiVersion()))).withNamespace(registryConfig.getParameter("namespace", base.getNamespace()))).withUsername(registryConfig.getParameter("username", base.getUsername()))).withPassword(registryConfig.getParameter("password", base.getPassword()))).withOauthToken(registryConfig.getParameter("oauthToken", base.getOauthToken()))).withCaCertFile(registryConfig.getParameter("caCertFile", base.getCaCertFile()))).withCaCertData(registryConfig.getParameter("caCertData", KubernetesConfigUtils.decodeBase64(base.getCaCertData())))).withClientKeyFile(registryConfig.getParameter("clientKeyFile", base.getClientKeyFile()))).withClientKeyData(registryConfig.getParameter("clientKeyData", KubernetesConfigUtils.decodeBase64(base.getClientKeyData())))).withClientCertFile(registryConfig.getParameter("clientCertFile", base.getClientCertFile()))).withClientCertData(registryConfig.getParameter("clientCertData", KubernetesConfigUtils.decodeBase64(base.getClientCertData())))).withClientKeyAlgo(registryConfig.getParameter("clientKeyAlgo", base.getClientKeyAlgo()))).withClientKeyPassphrase(registryConfig.getParameter("clientKeyPassphrase", base.getClientKeyPassphrase()))).withConnectionTimeout(registryConfig.getParameter("connectionTimeout", base.getConnectionTimeout()))).withRequestTimeout(registryConfig.getParameter("requestTimeout", base.getRequestTimeout()))).withWatchReconnectInterval(registryConfig.getParameter("watchReconnectInterval", base.getWatchReconnectInterval()))).withWatchReconnectLimit(registryConfig.getParameter("watchReconnectLimit", base.getWatchReconnectLimit()))).withLoggingInterval(registryConfig.getParameter("loggingInterval", base.getLoggingInterval()))).withTrustCerts(registryConfig.getParameter("trustCerts", base.isTrustCerts()))).withHttp2Disable(registryConfig.getParameter("http2Disable", base.isHttp2Disable()))).withHttpProxy(registryConfig.getParameter("httpProxy", base.getHttpProxy()))).withHttpsProxy(registryConfig.getParameter("httpsProxy", base.getHttpsProxy()))).withProxyUsername(registryConfig.getParameter("proxyUsername", base.getProxyUsername()))).withProxyPassword(registryConfig.getParameter("proxyPassword", base.getProxyPassword()))).build();
    }

    private static String buildMasterUrl(RegistryConfig registryConfig) {
        String address = registryConfig.getAddress();
        if (StringUtils.isBlank(address)) {
            return "https://kubernetes.default.svc";
        }
        if (address.startsWith("http")) {
            return address;
        }
        return registryConfig.getParameter("useHttps", true) ? "https://" + address : "http://" + address;
    }

    private static String decodeBase64(String str) {
        return StringUtils.isNotEmpty(str) ? new String(Base64.getDecoder().decode(str)) : null;
    }
}

