/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.hystrix.command;

import com.netflix.hystrix.HystrixCommand;
import java.net.URI;
import org.apache.shenyu.common.utils.UriUtils;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.hystrix.command.Command;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import rx.Observable;
import rx.RxReactiveStreams;

public class HystrixCommandOnThread
extends HystrixCommand<Mono<Void>>
implements Command {
    private static final Logger LOG = LoggerFactory.getLogger(HystrixCommandOnThread.class);
    private final ServerWebExchange exchange;
    private final ShenyuPluginChain chain;
    private final URI callBackUri;

    public HystrixCommandOnThread(HystrixCommand.Setter setter, ServerWebExchange exchange, ShenyuPluginChain chain, String callBackUri) {
        super(setter);
        this.exchange = exchange;
        this.chain = chain;
        this.callBackUri = UriUtils.createUri((String)callBackUri);
    }

    protected Mono<Void> run() {
        RxReactiveStreams.toObservable((Publisher)this.chain.execute(this.exchange)).toBlocking().subscribe();
        return Mono.empty();
    }

    protected Mono<Void> getFallback() {
        if (this.isFailedExecution()) {
            LOG.error("hystrix execute have error: ", this.getExecutionException());
        }
        Throwable exception = this.getExecutionException();
        return this.fallback(this.exchange, this.getCallBackUri(), exception);
    }

    @Override
    public Observable<Void> fetchObservable() {
        return RxReactiveStreams.toObservable((Publisher)((Publisher)this.execute()));
    }

    @Override
    public URI getCallBackUri() {
        return this.callBackUri;
    }

    @Override
    public void removeCommandKey(String commandKey) {
        executionSemaphorePerCircuit.remove(commandKey);
    }

    @Override
    public void cleanCommand() {
        executionSemaphorePerCircuit.clear();
    }
}

