/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.config.configcenter;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.config.configcenter.DynamicConfigurationFactory;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;

public abstract class AbstractDynamicConfigurationFactory
implements DynamicConfigurationFactory {
    private volatile ConcurrentHashMap<String, DynamicConfiguration> dynamicConfigurations = new ConcurrentHashMap();

    @Override
    public final DynamicConfiguration getDynamicConfiguration(URL url) {
        String key = url == null ? "default" : url.toServiceString();
        return ConcurrentHashMapUtils.computeIfAbsent(this.dynamicConfigurations, key, k -> this.createDynamicConfiguration(url));
    }

    protected abstract DynamicConfiguration createDynamicConfiguration(URL var1);
}

