/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.fastjson2;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONWriter;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.dubbo.common.serialize.ObjectOutput;
import org.apache.dubbo.common.serialize.fastjson2.Fastjson2CreatorManager;
import org.apache.dubbo.common.serialize.fastjson2.Fastjson2SecurityManager;

public class FastJson2ObjectOutput
implements ObjectOutput {
    private final Fastjson2CreatorManager fastjson2CreatorManager;
    private final Fastjson2SecurityManager fastjson2SecurityManager;
    private volatile ClassLoader classLoader;
    private final OutputStream os;

    public FastJson2ObjectOutput(Fastjson2CreatorManager fastjson2CreatorManager, Fastjson2SecurityManager fastjson2SecurityManager, OutputStream out) {
        this.fastjson2CreatorManager = fastjson2CreatorManager;
        this.fastjson2SecurityManager = fastjson2SecurityManager;
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.os = out;
        fastjson2CreatorManager.setCreator(this.classLoader);
    }

    @Override
    public void writeBool(boolean v) throws IOException {
        this.writeObject(v);
    }

    @Override
    public void writeByte(byte v) throws IOException {
        this.writeObject(v);
    }

    @Override
    public void writeShort(short v) throws IOException {
        this.writeObject(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.writeObject(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.writeObject(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeObject(Float.valueOf(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeObject(v);
    }

    @Override
    public void writeUTF(String v) throws IOException {
        this.writeObject(v);
    }

    @Override
    public void writeBytes(byte[] b) throws IOException {
        this.writeLength(b.length);
        this.os.write(b);
    }

    @Override
    public void writeBytes(byte[] b, int off, int len) throws IOException {
        this.writeLength(len);
        this.os.write(b, off, len);
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        this.updateClassLoaderIfNeed();
        byte[] bytes = this.fastjson2SecurityManager.getSecurityFilter().isCheckSerializable() ? JSONB.toBytes((Object)obj, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteClassName, JSONWriter.Feature.FieldBased, JSONWriter.Feature.ErrorOnNoneSerializable, JSONWriter.Feature.ReferenceDetection, JSONWriter.Feature.WriteNulls, JSONWriter.Feature.NotWriteDefaultValue, JSONWriter.Feature.NotWriteHashMapArrayListClassName, JSONWriter.Feature.WriteNameAsSymbol}) : JSONB.toBytes((Object)obj, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteClassName, JSONWriter.Feature.FieldBased, JSONWriter.Feature.ReferenceDetection, JSONWriter.Feature.WriteNulls, JSONWriter.Feature.NotWriteDefaultValue, JSONWriter.Feature.NotWriteHashMapArrayListClassName, JSONWriter.Feature.WriteNameAsSymbol});
        this.writeLength(bytes.length);
        this.os.write(bytes);
        this.os.flush();
    }

    private void updateClassLoaderIfNeed() {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        if (currentClassLoader != this.classLoader) {
            this.fastjson2CreatorManager.setCreator(currentClassLoader);
            this.classLoader = currentClassLoader;
        }
    }

    private void writeLength(int value) throws IOException {
        byte[] bytes = new byte[4];
        int length = bytes.length;
        for (int i = 0; i < length; ++i) {
            bytes[length - i - 1] = (byte)(value & 0xFF);
            value >>= 8;
        }
        this.os.write(bytes);
    }

    @Override
    public void flushBuffer() throws IOException {
        this.os.flush();
    }
}

