/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.reactive;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.dubbo.reactive.AbstractTripleReactorSubscriber;
import org.apache.dubbo.rpc.CancellationContext;
import org.apache.dubbo.rpc.protocol.tri.CancelableStreamObserver;
import org.apache.dubbo.rpc.protocol.tri.observer.CallStreamObserver;

public class ServerTripleReactorSubscriber<T>
extends AbstractTripleReactorSubscriber<T> {
    private final CompletableFuture<List<T>> executionFuture = new CompletableFuture();
    private final List<T> collectedData = new ArrayList<T>();

    public ServerTripleReactorSubscriber() {
    }

    public ServerTripleReactorSubscriber(CallStreamObserver<T> streamObserver) {
        this.downstream = streamObserver;
    }

    @Override
    public void subscribe(CallStreamObserver<T> downstream) {
        super.subscribe(downstream);
        if (downstream instanceof CancelableStreamObserver) {
            CancellationContext context;
            CancelableStreamObserver observer = (CancelableStreamObserver)((Object)downstream);
            if (observer.getCancellationContext() == null) {
                context = new CancellationContext();
                observer.setCancellationContext(context);
            } else {
                context = observer.getCancellationContext();
            }
            context.addListener(ctx -> super.cancel());
        }
    }

    @Override
    public void onNext(T t) {
        super.onNext(t);
        this.collectedData.add(t);
    }

    @Override
    public void onError(Throwable throwable) {
        super.onError(throwable);
        this.executionFuture.completeExceptionally(throwable);
    }

    @Override
    public void onComplete() {
        super.onComplete();
        this.executionFuture.complete(this.collectedData);
    }

    public CompletableFuture<List<T>> getExecutionFuture() {
        return this.executionFuture;
    }
}

