/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.api.connection;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.api.connection.AbstractConnectionClient;
import org.apache.dubbo.remoting.api.connection.ConnectionManager;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class MultiplexProtocolConnectionManager
implements ConnectionManager {
    public static final String NAME = "multiple";
    private final ConcurrentMap<String, ConnectionManager> protocols = new ConcurrentHashMap<String, ConnectionManager>(1);
    private FrameworkModel frameworkModel;

    public MultiplexProtocolConnectionManager(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    @Override
    public AbstractConnectionClient connect(URL url, ChannelHandler handler) {
        ConnectionManager manager = ConcurrentHashMapUtils.computeIfAbsent(this.protocols, url.getProtocol(), this::createSingleProtocolConnectionManager);
        return manager.connect(url, handler);
    }

    @Override
    public void forEachConnection(Consumer<AbstractConnectionClient> connectionConsumer) {
        this.protocols.values().forEach(p -> p.forEachConnection(connectionConsumer));
    }

    private ConnectionManager createSingleProtocolConnectionManager(String protocol) {
        return this.frameworkModel.getExtensionLoader(ConnectionManager.class).getExtension("single");
    }
}

