/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.rpc.Invocation;

public class RequestTemplate
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String CONTENT_ENCODING = "Content-Encoding";
    private static final String CONTENT_LENGTH = "Content-Length";
    public static final String ENCODING_GZIP = "gzip";
    public static final String ENCODING_DEFLATE = "deflate";
    private static final List<String> EMPTY_ARRAYLIST = new ArrayList<String>();
    private final Map<String, Collection<String>> queries = new LinkedHashMap<String, Collection<String>>();
    private final Map<String, Collection<String>> headers = new LinkedHashMap<String, Collection<String>>();
    private String httpMethod;
    private String path;
    private String address;
    private Object body;
    private byte[] byteBody = new byte[0];
    private String protocol = "http://";
    private final Invocation invocation;
    private String contextPath = "";
    private Class<?> bodyType;

    public RequestTemplate(Invocation invocation, String httpMethod, String address) {
        this(invocation, httpMethod, address, "");
    }

    public RequestTemplate(Invocation invocation, String httpMethod, String address, String contextPath) {
        this.httpMethod = httpMethod;
        this.address = address;
        this.invocation = invocation;
        this.contextPath = contextPath;
    }

    public String getURL() {
        StringBuilder stringBuilder = new StringBuilder(this.getProtocol() + this.address);
        stringBuilder.append(this.getUri());
        return stringBuilder.toString();
    }

    public String getUri() {
        StringBuilder stringBuilder = new StringBuilder(this.getContextPath() + this.path);
        return stringBuilder.append(this.getQueryString()).toString();
    }

    public String getQueryString() {
        if (this.queries.isEmpty()) {
            return "";
        }
        StringBuilder queryBuilder = new StringBuilder("?");
        for (String field : this.queries.keySet()) {
            Collection<String> queryValues = this.queries.get(field);
            if (queryValues == null || queryValues.isEmpty()) continue;
            for (String value : queryValues) {
                queryBuilder.append('&');
                queryBuilder.append(field);
                if (value == null) continue;
                queryBuilder.append('=');
                queryBuilder.append(value);
            }
        }
        return queryBuilder.toString().replace("?&", "?");
    }

    public RequestTemplate path(String path) {
        this.path = path;
        return this;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public RequestTemplate httpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    public byte[] getSerializedBody() {
        return this.byteBody;
    }

    public void serializeBody(byte[] body) {
        this.addHeader(CONTENT_LENGTH, body.length);
        this.byteBody = body;
    }

    public boolean isBodyEmpty() {
        return this.getUnSerializedBody() == null;
    }

    public RequestTemplate body(Object body, Class bodyType) {
        this.body = body;
        this.setBodyType(bodyType);
        return this;
    }

    public Object getUnSerializedBody() {
        return this.body;
    }

    public Map<String, Collection<String>> getAllHeaders() {
        return this.headers;
    }

    public Collection<String> getHeaders(String name) {
        return this.headers.get(name);
    }

    public String getHeader(String name) {
        if (this.headers.containsKey(name)) {
            Collection<String> headers = this.getHeaders(name);
            if (headers.isEmpty()) {
                return null;
            }
            String[] strings = headers.toArray(new String[0]);
            return strings[0];
        }
        return null;
    }

    public Collection<String> getEncodingValues() {
        if (this.headers.containsKey(CONTENT_ENCODING)) {
            return this.headers.get(CONTENT_ENCODING);
        }
        return EMPTY_ARRAYLIST;
    }

    public boolean isGzipEncodedRequest() {
        return this.getEncodingValues().contains(ENCODING_GZIP);
    }

    public boolean isDeflateEncodedRequest() {
        return this.getEncodingValues().contains(ENCODING_DEFLATE);
    }

    public void addHeader(String key, String value) {
        this.addValueByKey(key, value, this.headers);
    }

    public void addHeader(String key, Object value) {
        this.addValueByKey(key, String.valueOf(value), this.headers);
    }

    public void addKeepAliveHeader(int time) {
        this.addHeader("Keep-Alive", time);
        this.addHeader("Connection", "keep-alive");
    }

    public void addHeaders(String key, Collection<String> values) {
        Collection<String> header = this.getHeaders(key);
        if (header == null) {
            header = new HashSet<String>();
            this.headers.put(key, header);
        }
        header.addAll(values);
    }

    public void addParam(String key, String value) {
        this.addValueByKey(key, value, this.queries);
    }

    public void addParam(String key, Object value) {
        this.addParam(key, String.valueOf(value));
    }

    public Map<String, Collection<String>> getQueries() {
        return this.queries;
    }

    public Collection<String> getParam(String key) {
        return this.getQueries().get(key);
    }

    public void addParams(String key, Collection<String> values) {
        Collection<String> params = this.getParam(key);
        if (params == null) {
            params = new HashSet<String>();
            this.queries.put(key, params);
        }
        params.addAll(values);
    }

    public void addValueByKey(String key, String value, Map<String, Collection<String>> maps) {
        if (value == null) {
            return;
        }
        Collection<Object> values = null;
        if (!maps.containsKey(key)) {
            values = new HashSet();
            maps.put(key, values);
        }
        values = maps.get(key);
        values.add(value);
    }

    public Integer getContentLength() {
        if (!this.getAllHeaders().containsKey(CONTENT_LENGTH)) {
            return null;
        }
        HashSet strings = (HashSet)this.getAllHeaders().get(CONTENT_LENGTH);
        return Integer.parseInt((String)new ArrayList(strings).get(0));
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.addHeader("Host", address);
        this.address = address;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public Invocation getInvocation() {
        return this.invocation;
    }

    public String getContextPath() {
        if (this.contextPath == null || this.contextPath.length() == 0) {
            return "";
        }
        if (this.contextPath.startsWith("/")) {
            return this.contextPath;
        }
        return "/" + this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public Class<?> getBodyType() {
        return this.bodyType;
    }

    public void setBodyType(Class<?> bodyType) {
        this.bodyType = bodyType;
    }
}

