/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.mesh.route;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.config.configcenter.ConfigChangeType;
import org.apache.dubbo.common.config.configcenter.ConfigChangedEvent;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.cluster.router.mesh.util.MeshRuleDispatcher;
import org.apache.dubbo.rpc.cluster.router.mesh.util.MeshRuleListener;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.representer.Representer;

public class MeshAppRuleListener
implements ConfigurationListener {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(MeshAppRuleListener.class);
    private final MeshRuleDispatcher meshRuleDispatcher;
    private final String appName;
    private volatile Map<String, List<Map<String, Object>>> ruleMapHolder;

    public MeshAppRuleListener(String appName) {
        this.appName = appName;
        this.meshRuleDispatcher = new MeshRuleDispatcher(appName);
    }

    public void receiveConfigInfo(String configInfo) {
        if (logger.isDebugEnabled()) {
            logger.debug(MessageFormat.format("[MeshAppRule] Received rule for app [{0}]: {1}.", this.appName, configInfo));
        }
        try {
            HashMap<String, List<Map<String, Object>>> groupMap = new HashMap<String, List<Map<String, Object>>>();
            Representer representer = new Representer(new DumperOptions());
            representer.getPropertyUtils().setSkipMissingProperties(true);
            Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()), representer);
            Iterable yamlIterator = yaml.loadAll(configInfo);
            for (Object obj : yamlIterator) {
                if (obj instanceof Map) {
                    Map resultMap = (Map)obj;
                    String ruleType = this.computeRuleType(resultMap);
                    if (ruleType != null) {
                        groupMap.computeIfAbsent(ruleType, k -> new LinkedList()).add(resultMap);
                        continue;
                    }
                    logger.error("2-13", "receive mesh app route rule is invalid", "", "Unable to get rule type from raw rule. Probably the metadata.name is absent. App Name: " + this.appName + " RawRule: " + configInfo);
                    continue;
                }
                logger.error("2-13", "receive mesh app route rule is invalid", "", "Rule format is unacceptable. App Name: " + this.appName + " RawRule: " + configInfo);
            }
            this.ruleMapHolder = groupMap;
        }
        catch (Exception e) {
            logger.error("2-13", "failed to receive mesh app route rule", "", "[MeshAppRule] parse failed: " + configInfo, e);
        }
        if (this.ruleMapHolder != null) {
            this.meshRuleDispatcher.post(this.ruleMapHolder);
        }
    }

    private String computeRuleType(Map<String, Object> rule) {
        Object obj = rule.get("metadata");
        if (obj instanceof Map && CollectionUtils.isNotEmptyMap((Map)obj)) {
            Map metadata = (Map)obj;
            String name = (String)metadata.get("name");
            if (!name.contains(".")) {
                return "standard";
            }
            return name.substring(name.indexOf(".") + 1);
        }
        return null;
    }

    public <T> void register(MeshRuleListener subscriber) {
        List<Map<String, Object>> rule;
        if (this.ruleMapHolder != null && (rule = this.ruleMapHolder.get(subscriber.ruleSuffix())) != null) {
            subscriber.onRuleChange(this.appName, rule);
        }
        this.meshRuleDispatcher.register(subscriber);
    }

    public <T> void unregister(MeshRuleListener subscriber) {
        this.meshRuleDispatcher.unregister(subscriber);
    }

    @Override
    public void process(ConfigChangedEvent event) {
        if (event.getChangeType() == ConfigChangeType.DELETED) {
            this.receiveConfigInfo("");
            return;
        }
        this.receiveConfigInfo(event.getContent());
    }

    public boolean isEmpty() {
        return this.meshRuleDispatcher.isEmpty();
    }

    @Deprecated
    public MeshRuleDispatcher getMeshRuleDispatcher() {
        return this.meshRuleDispatcher;
    }
}

