/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.codec;

import com.weibo.api.motan.codec.Codec;
import com.weibo.api.motan.codec.Serialization;
import com.weibo.api.motan.core.extension.ExtensionLoader;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.util.LoggerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractCodec
implements Codec {
    protected static ConcurrentHashMap<Integer, String> serializations;

    protected void serialize(ObjectOutput output, Object message, Serialization serialize) throws IOException {
        if (message == null) {
            output.writeObject(null);
            return;
        }
        output.writeObject(serialize.serialize(message));
    }

    protected Object deserialize(byte[] value, Class<?> type, Serialization serialize) throws IOException {
        if (value == null) {
            return null;
        }
        return serialize.deserialize(value, type);
    }

    public ObjectOutput createOutput(OutputStream outputStream) {
        try {
            return new ObjectOutputStream(outputStream);
        }
        catch (Exception e) {
            throw new MotanFrameworkException(this.getClass().getSimpleName() + " createOutput error", e, MotanErrorMsgConstant.FRAMEWORK_ENCODE_ERROR);
        }
    }

    public ObjectInput createInput(InputStream in) {
        try {
            return new ObjectInputStream(in);
        }
        catch (Exception e) {
            throw new MotanFrameworkException(this.getClass().getSimpleName() + " createInput error", e, MotanErrorMsgConstant.FRAMEWORK_DECODE_ERROR);
        }
    }

    protected static synchronized void initAllSerialization() {
        if (serializations == null) {
            serializations = new ConcurrentHashMap();
            try {
                ExtensionLoader<Serialization> loader = ExtensionLoader.getExtensionLoader(Serialization.class);
                List<Serialization> exts = loader.getExtensions(null);
                for (Serialization s : exts) {
                    String old = serializations.put(s.getSerializationNumber(), loader.getSpiName(s.getClass()));
                    if (old == null) continue;
                    LoggerUtil.warn("conflict serialization spi! serialization num :" + s.getSerializationNumber() + ", old spi :" + old + ", new spi :" + serializations.get(s.getSerializationNumber()));
                }
            }
            catch (Exception e) {
                LoggerUtil.warn("init all serialzaion fail!", e);
            }
        }
    }

    protected Serialization getSerializationByNum(int serializationNum) {
        if (serializations == null) {
            AbstractCodec.initAllSerialization();
        }
        String name = serializations.get(serializationNum);
        Serialization s = null;
        if (StringUtils.isNotBlank((CharSequence)name)) {
            s = ExtensionLoader.getExtensionLoader(Serialization.class).getExtension(name, false);
        }
        if (s == null) {
            throw new MotanServiceException("can not found serialization by number " + serializationNum + ", name: " + name);
        }
        return s;
    }
}

