/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.rewrite;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.RewriteHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.cache.MetaDataCache;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.base.utils.PathMatchUtils;
import org.apache.shenyu.plugin.rewrite.handler.RewritePluginDataHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RewritePlugin
extends AbstractShenyuPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(RewritePlugin.class);

    protected String getRawPath(ServerWebExchange exchange) {
        String rewriteContextPath = (String)exchange.getAttribute("rewrite_context_path");
        if (StringUtils.isBlank((CharSequence)rewriteContextPath)) {
            return super.getRawPath(exchange);
        }
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        Objects.requireNonNull(shenyuContext);
        return rewriteContextPath + shenyuContext.getRealUrl();
    }

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        String handle = rule.getHandle();
        RewriteHandle rewriteHandle = (RewriteHandle)RewritePluginDataHandler.CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
        if (Objects.isNull(rewriteHandle)) {
            LOG.error("uri rewrite rule can not configuration\uff1a{}", (Object)handle);
            return chain.execute(exchange);
        }
        String rewriteUri = this.getRawPath(exchange);
        Integer percentage = Optional.ofNullable(rewriteHandle.getPercentage()).orElse(100);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{rewriteHandle.getRegex(), rewriteHandle.getReplace()}) && ThreadLocalRandom.current().nextInt(100) < percentage) {
            rewriteUri = rewriteHandle.getReplace().contains("{") ? PathMatchUtils.replaceAll((String)rewriteHandle.getReplace(), (String)rewriteHandle.getRegex().substring(rewriteHandle.getRegex().indexOf("{")), (String)rewriteUri.substring(rewriteHandle.getRegex().indexOf("{") + 1)) : rewriteUri.replaceAll(rewriteHandle.getRegex(), rewriteHandle.getReplace());
            Map attributes = exchange.getAttributes();
            if (Optional.ofNullable(rewriteHandle.getRewriteMetaData()).orElse(false).booleanValue()) {
                String contextPath = Optional.ofNullable((String)exchange.getAttribute("rewrite_context_path")).orElseGet(() -> (String)exchange.getAttribute("contextPath"));
                MetaData metaData = MetaDataCache.getInstance().obtain(contextPath + rewriteUri);
                Optional.ofNullable(exchange.getAttribute("metaData")).ifPresent(metadata -> attributes.put("old_context_path_meta_data", metadata));
                if (Objects.nonNull(metaData)) {
                    attributes.put("metaData", metaData);
                }
                ShenyuContext context = (ShenyuContext)exchange.getAttribute("context");
                Objects.requireNonNull(context);
                if (Objects.nonNull(metaData) && Boolean.TRUE.equals(metaData.getEnabled())) {
                    context.setRpcType(metaData.getRpcType());
                } else {
                    context.setRpcType(RpcTypeEnum.HTTP.getName());
                }
            }
            attributes.put("rewrite_uri", rewriteUri);
        }
        return chain.execute(exchange);
    }

    public String named() {
        return PluginEnum.REWRITE.getName();
    }

    public int getOrder() {
        return PluginEnum.REWRITE.getCode();
    }
}

