/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.loader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.shenyu.common.exception.ShenyuException;

public class PluginJarParser {
    public static PluginJar parseJar(byte[] jarBytes) {
        PluginJar pluginJar = new PluginJar();
        try (JarInputStream jarInputStream = new JarInputStream(new ByteArrayInputStream(jarBytes));){
            JarEntry jarEntry;
            while (Objects.nonNull(jarEntry = jarInputStream.getNextJarEntry())) {
                String entryName = jarEntry.getName();
                if (jarEntry.getName().endsWith("pom.properties")) {
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    try {
                        int data;
                        while ((data = jarInputStream.read()) != -1) {
                            buffer.write(data);
                        }
                        buffer.flush();
                        byte[] classByteArray = buffer.toByteArray();
                        Properties properties = new Properties();
                        properties.load(new ByteArrayInputStream(classByteArray));
                        pluginJar.version = properties.get("version").toString();
                        pluginJar.artifactId = properties.get("artifactId").toString();
                        pluginJar.groupId = properties.get("groupId").toString();
                        continue;
                    }
                    finally {
                        buffer.close();
                        continue;
                    }
                }
                if (!jarEntry.isDirectory() && entryName.endsWith(".class") && !entryName.contains("$")) {
                    String className = jarEntry.getName().substring(0, entryName.length() - 6).replaceAll("/", ".");
                    pluginJar.clazzMap.put(className, PluginJarParser.getClassByteArray(jarInputStream));
                    continue;
                }
                pluginJar.resourceMap.put(jarEntry.getName(), PluginJarParser.getClassByteArray(jarInputStream));
            }
        }
        catch (IOException e) {
            throw new ShenyuException("load jar classes find error");
        }
        return pluginJar;
    }

    private static byte[] getClassByteArray(JarInputStream jarInputStream) {
        byte[] byArray;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            int data;
            while ((data = jarInputStream.read()) != -1) {
                buffer.write(data);
            }
            buffer.flush();
            byArray = buffer.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ShenyuException("load jar classes find error");
            }
        }
        buffer.close();
        return byArray;
    }

    public static class PluginJar {
        private String absolutePath;
        private String groupId;
        private String artifactId;
        private String version;
        private Map<String, byte[]> clazzMap = new ConcurrentHashMap<String, byte[]>();
        private Map<String, byte[]> resourceMap = new ConcurrentHashMap<String, byte[]>();

        public String getAbsolutePath() {
            return this.absolutePath;
        }

        public void setAbsolutePath(String absolutePath) {
            this.absolutePath = absolutePath;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public Map<String, byte[]> getClazzMap() {
            return this.clazzMap;
        }

        public void setClazzMap(Map<String, byte[]> clazzMap) {
            this.clazzMap = clazzMap;
        }

        public String getJarKey() {
            return String.format("%s:%s", this.groupId, this.artifactId);
        }

        public Map<String, byte[]> getResourceMap() {
            return this.resourceMap;
        }

        public void setResourceMap(Map<String, byte[]> resourceMap) {
            this.resourceMap = resourceMap;
        }
    }
}

