/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.common.AliyunADBSink;
import com.aliyun.openservices.log.common.AliyunTSDBSink;
import com.aliyun.openservices.log.common.DataSink;
import com.aliyun.openservices.log.common.DataSinkType;
import com.aliyun.openservices.log.common.JobConfiguration;
import com.aliyun.openservices.log.util.JsonUtils;
import java.util.Map;

public class ExportConfiguration
extends JobConfiguration {
    private String logstore;
    private String accessKeyId;
    private String accessKeySecret;
    private String roleArn;
    private String instanceType;
    private int fromTime;
    private DataSink sink;
    private Map<String, String> parameters;

    public String getLogstore() {
        return this.logstore;
    }

    public void setLogstore(String logstore) {
        this.logstore = logstore;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public int getFromTime() {
        return this.fromTime;
    }

    public void setFromTime(int fromTime) {
        this.fromTime = fromTime;
    }

    public DataSink getSink() {
        return this.sink;
    }

    public void setSink(DataSink sink) {
        this.sink = sink;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    @Override
    public void deserialize(JSONObject value) {
        this.logstore = value.getString("logstore");
        this.roleArn = value.getString("roleArn");
        this.accessKeyId = value.getString("accessKeyId");
        this.accessKeySecret = value.getString("accessKeySecret");
        this.instanceType = value.getString("instanceType");
        this.fromTime = value.getIntValue("fromTime");
        JSONObject obj = value.getJSONObject("sink");
        DataSinkType type = DataSinkType.fromString(obj.getString("type"));
        if (type == DataSinkType.ALIYUN_ADB) {
            this.sink = new AliyunADBSink();
            this.sink.deserialize(obj);
        } else if (type == DataSinkType.ALIYUN_TSDB) {
            this.sink = new AliyunTSDBSink();
            this.sink.deserialize(obj);
        }
        this.parameters = JsonUtils.readOptionalMap(value, "parameters");
    }
}

