/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ai.prompt;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.plugin.AiPromptConfig;
import org.apache.shenyu.common.dto.convert.rule.AiPromptHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.ai.prompt.handler.AiPromptPluginDataHandler;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.exception.ResponsiveException;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.base.utils.ServerWebExchangeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class AiPromptPlugin
extends AbstractShenyuPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(AiPromptPlugin.class);
    private final List<HttpMessageReader<?>> messageReaders;

    public AiPromptPlugin(List<HttpMessageReader<?>> messageReaders) {
        this.messageReaders = messageReaders;
    }

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        AiPromptHandle aiPromptHandle;
        AiPromptConfig aiPromptConfig = (AiPromptConfig)Singleton.INST.get(AiPromptConfig.class);
        if (Objects.isNull(aiPromptConfig)) {
            aiPromptConfig = new AiPromptConfig();
        }
        if (Objects.nonNull(aiPromptHandle = (AiPromptHandle)AiPromptPluginDataHandler.CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule)))) {
            aiPromptConfig.setPreRole(aiPromptHandle.getPreRole());
            aiPromptConfig.setPrepend(aiPromptHandle.getPrepend());
            aiPromptConfig.setPostRole(aiPromptHandle.getPostRole());
            aiPromptConfig.setAppend(aiPromptHandle.getAppend());
        }
        AiPromptConfig finalAiPromptConfig = aiPromptConfig;
        return ServerWebExchangeUtils.rewriteRequestBody((ServerWebExchange)exchange, this.messageReaders, originalBody -> Mono.just((Object)this.decorateBody((String)originalBody, finalAiPromptConfig))).flatMap(arg_0 -> ((ShenyuPluginChain)chain).execute(arg_0)).onErrorResume(error -> {
            if (error instanceof ResponsiveException) {
                return WebFluxResultUtils.failedResult((ResponsiveException)((ResponsiveException)error));
            }
            return Mono.error((Throwable)error);
        });
    }

    private String decorateBody(String originalBody, AiPromptConfig aiPromptConfig) {
        Map requestBodyMap = GsonUtils.getInstance().convertToMap(originalBody);
        Object rawMessages = requestBodyMap.get("messages");
        if (Objects.isNull(rawMessages)) {
            return originalBody;
        }
        List messages = (List)rawMessages;
        if (CollectionUtils.isEmpty((Collection)messages)) {
            return originalBody;
        }
        ArrayList decoratedMessages = Lists.newArrayList();
        if (Objects.nonNull(aiPromptConfig.getPrepend()) && Objects.nonNull(aiPromptConfig.getPreRole())) {
            HashMap prependMap = Maps.newHashMap();
            prependMap.put("content", aiPromptConfig.getPrepend());
            prependMap.put("role", aiPromptConfig.getPreRole());
            decoratedMessages.add(prependMap);
        }
        decoratedMessages.add(messages.get(0));
        if (Objects.nonNull(aiPromptConfig.getAppend()) && Objects.nonNull(aiPromptConfig.getPostRole())) {
            HashMap appendMap = Maps.newHashMap();
            appendMap.put("content", aiPromptConfig.getAppend());
            appendMap.put("role", aiPromptConfig.getPostRole());
            decoratedMessages.add(appendMap);
        }
        requestBodyMap.put("messages", decoratedMessages);
        return GsonUtils.getInstance().toJson((Object)requestBodyMap);
    }

    public String named() {
        return PluginEnum.AI_PROMPT.getName();
    }

    public int getOrder() {
        return PluginEnum.AI_PROMPT.getCode();
    }
}

