/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.ssl;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Objects;
import org.springframework.util.Assert;

class CertificateMatcher {
    private static final byte[] DATA = new byte[256];
    private final PrivateKey privateKey;
    private final Signature signature;
    private final byte[] generatedSignature;

    CertificateMatcher(PrivateKey privateKey) {
        Assert.notNull((Object)privateKey, (String)"Private key must not be null");
        this.privateKey = privateKey;
        this.signature = this.createSignature(privateKey);
        Assert.notNull((Object)this.signature, (String)"Failed to create signature");
        this.generatedSignature = CertificateMatcher.sign(this.signature, privateKey);
    }

    private Signature createSignature(PrivateKey privateKey) {
        try {
            String algorithm = CertificateMatcher.getSignatureAlgorithm(privateKey);
            return algorithm != null ? Signature.getInstance(algorithm) : null;
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
    }

    private static String getSignatureAlgorithm(PrivateKey privateKey) {
        return switch (privateKey.getAlgorithm()) {
            case "RSA" -> "SHA256withRSA";
            case "DSA" -> "SHA256withDSA";
            case "EC" -> "SHA256withECDSA";
            case "EdDSA" -> "EdDSA";
            default -> null;
        };
    }

    boolean matchesAny(List<? extends Certificate> certificates) {
        return this.generatedSignature != null && certificates.stream().anyMatch(this::matches);
    }

    boolean matches(Certificate certificate) {
        return this.matches(certificate.getPublicKey());
    }

    private boolean matches(PublicKey publicKey) {
        return this.generatedSignature != null && Objects.equals(this.privateKey.getAlgorithm(), publicKey.getAlgorithm()) && this.verify(publicKey);
    }

    private boolean verify(PublicKey publicKey) {
        try {
            this.signature.initVerify(publicKey);
            this.signature.update(DATA);
            return this.signature.verify(this.generatedSignature);
        }
        catch (InvalidKeyException | SignatureException ex) {
            return false;
        }
    }

    private static byte[] sign(Signature signature, PrivateKey privateKey) {
        try {
            signature.initSign(privateKey);
            signature.update(DATA);
            return signature.sign();
        }
        catch (InvalidKeyException | SignatureException ex) {
            return null;
        }
    }

    static {
        for (int i = 0; i < DATA.length; ++i) {
            CertificateMatcher.DATA[i] = (byte)i;
        }
    }
}

