/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.plugin.mcp.server;

import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.mcp.server.McpServerPlugin;
import org.apache.shenyu.plugin.mcp.server.handler.McpServerPluginDataHandler;
import org.apache.shenyu.plugin.mcp.server.manager.ShenyuMcpServerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.http.codec.ServerCodecConfigurer;

@ConditionalOnProperty(prefix="shenyu.plugins.mcp.server", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class McpServerPluginConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(McpServerPluginConfiguration.class);

    @Bean
    public ShenyuMcpServerManager shenyuMcpServerManager() {
        return new ShenyuMcpServerManager();
    }

    @Bean
    public PluginDataHandler mcpServerPluginDataHandler(ShenyuMcpServerManager shenyuMcpServerManager) {
        return new McpServerPluginDataHandler(shenyuMcpServerManager);
    }

    @Bean
    public ShenyuPlugin mcpServerPlugin(ShenyuMcpServerManager shenyuMcpServerManager, ServerCodecConfigurer configurer) {
        return new McpServerPlugin(shenyuMcpServerManager, configurer.getReaders());
    }
}

