/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.log.proxy;

import com.alipay.sofa.common.log.LoggerSpaceManager;
import com.alipay.sofa.common.log.proxy.TemporaryILoggerFactory;
import com.alipay.sofa.common.space.SpaceId;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryILoggerFactoryPool {
    private static final ConcurrentHashMap<SpaceIdWithClassloader, TemporaryILoggerFactory> temporaryILoggerFactoryMap = new ConcurrentHashMap();
    private static final Logger logger = LoggerFactory.getLogger(LoggerSpaceManager.class);

    public static TemporaryILoggerFactory get(String space, ClassLoader spaceClassLoader) {
        return TemporaryILoggerFactoryPool.get(new SpaceId(space), spaceClassLoader);
    }

    public static TemporaryILoggerFactory get(SpaceId spaceId, ClassLoader spaceClassLoader) {
        TemporaryILoggerFactory temporaryILoggerFactory = temporaryILoggerFactoryMap.get(new SpaceIdWithClassloader(spaceId, spaceClassLoader));
        if (temporaryILoggerFactory != null) {
            return temporaryILoggerFactory;
        }
        temporaryILoggerFactory = new TemporaryILoggerFactory(spaceId, spaceClassLoader, logger);
        temporaryILoggerFactoryMap.putIfAbsent(new SpaceIdWithClassloader(spaceId, spaceClassLoader), temporaryILoggerFactory);
        return temporaryILoggerFactory;
    }

    private static class SpaceIdWithClassloader {
        private SpaceId spaceId;
        private ClassLoader classLoader;

        public SpaceIdWithClassloader() {
        }

        public SpaceIdWithClassloader(SpaceId spaceId, ClassLoader classLoader) {
            this.spaceId = spaceId;
            this.classLoader = classLoader;
        }

        public SpaceId getSpaceId() {
            return this.spaceId;
        }

        public void setSpaceId(SpaceId spaceId) {
            this.spaceId = spaceId;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public void setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SpaceIdWithClassloader that = (SpaceIdWithClassloader)o;
            if (this.spaceId != null ? !this.spaceId.equals(that.spaceId) : that.spaceId != null) {
                return false;
            }
            return this.classLoader != null ? this.classLoader.equals(that.classLoader) : that.classLoader == null;
        }

        public int hashCode() {
            int result = this.spaceId != null ? this.spaceId.hashCode() : 0;
            result = 31 * result + (this.classLoader != null ? this.classLoader.hashCode() : 0);
            return result;
        }
    }
}

