/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.tracer;

import com.alipay.sofa.common.tracer.TracerIdRetriever;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracerIdAdapter {
    private static final Logger logger = LoggerFactory.getLogger(TracerIdAdapter.class);
    private static final TracerIdAdapter INSTANCE = new TracerIdAdapter();
    private TracerIdRetriever tracerIdRetriever;

    private TracerIdAdapter() {
        ServiceLoader<TracerIdRetriever> serviceLoader = ServiceLoader.load(TracerIdRetriever.class);
        Iterator<TracerIdRetriever> tracerIdAdapterIterator = serviceLoader.iterator();
        if (tracerIdAdapterIterator.hasNext()) {
            this.tracerIdRetriever = tracerIdAdapterIterator.next();
            logger.info("TracerIdConverter use tracerIdAdapter '{}'", (Object)this.tracerIdRetriever.getClass().getName());
        } else {
            logger.info("TracerIdConverter can not find any tracerIdAdapter");
        }
    }

    public static TracerIdAdapter getInstance() {
        return INSTANCE;
    }

    public String traceIdSafari(Thread t) {
        if (this.tracerIdRetriever == null) {
            return null;
        }
        try {
            return this.tracerIdRetriever.getTracerId(t);
        }
        catch (Exception e) {
            return null;
        }
    }
}

