/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.NlpBertTokenizationConfig;
import co.elastic.clients.elasticsearch.ml.NlpRobertaTokenizationConfig;
import co.elastic.clients.elasticsearch.ml.TokenizationConfigVariant;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class TokenizationConfig
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<TokenizationConfig> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TokenizationConfig::setupTokenizationConfigDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public TokenizationConfig(TokenizationConfigVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._tokenizationConfigKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private TokenizationConfig(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static TokenizationConfig of(Function<Builder, ObjectBuilder<TokenizationConfig>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isBert() {
        return this._kind == Kind.Bert;
    }

    public NlpBertTokenizationConfig bert() {
        return (NlpBertTokenizationConfig)TaggedUnionUtils.get(this, Kind.Bert);
    }

    public boolean isMpnet() {
        return this._kind == Kind.Mpnet;
    }

    public NlpBertTokenizationConfig mpnet() {
        return (NlpBertTokenizationConfig)TaggedUnionUtils.get(this, Kind.Mpnet);
    }

    public boolean isRoberta() {
        return this._kind == Kind.Roberta;
    }

    public NlpRobertaTokenizationConfig roberta() {
        return (NlpRobertaTokenizationConfig)TaggedUnionUtils.get(this, Kind.Roberta);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTokenizationConfigDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::bert, NlpBertTokenizationConfig._DESERIALIZER, "bert");
        op.add(Builder::mpnet, NlpBertTokenizationConfig._DESERIALIZER, "mpnet");
        op.add(Builder::roberta, NlpRobertaTokenizationConfig._DESERIALIZER, "roberta");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TokenizationConfig> {
        private Kind _kind;
        private Object _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<TokenizationConfig> bert(NlpBertTokenizationConfig v) {
            this._kind = Kind.Bert;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenizationConfig> bert(Function<NlpBertTokenizationConfig.Builder, ObjectBuilder<NlpBertTokenizationConfig>> fn) {
            return this.bert(fn.apply(new NlpBertTokenizationConfig.Builder()).build());
        }

        public ObjectBuilder<TokenizationConfig> mpnet(NlpBertTokenizationConfig v) {
            this._kind = Kind.Mpnet;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenizationConfig> mpnet(Function<NlpBertTokenizationConfig.Builder, ObjectBuilder<NlpBertTokenizationConfig>> fn) {
            return this.mpnet(fn.apply(new NlpBertTokenizationConfig.Builder()).build());
        }

        public ObjectBuilder<TokenizationConfig> roberta(NlpRobertaTokenizationConfig v) {
            this._kind = Kind.Roberta;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TokenizationConfig> roberta(Function<NlpRobertaTokenizationConfig.Builder, ObjectBuilder<NlpRobertaTokenizationConfig>> fn) {
            return this.roberta(fn.apply(new NlpRobertaTokenizationConfig.Builder()).build());
        }

        @Override
        public TokenizationConfig build() {
            this._checkSingleUse();
            return new TokenizationConfig(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Bert("bert"),
        Mpnet("mpnet"),
        Roberta("roberta");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

