/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.api.result;

import java.util.Objects;
import java.util.Optional;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.common.utils.ObjectTypeUtils;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.server.ServerWebExchange;
import reactor.netty.http.client.HttpClientResponse;

public interface ShenyuResult<T> {
    default public Object result(ServerWebExchange exchange, Object formatted) {
        return formatted;
    }

    default public Object format(ServerWebExchange exchange, Object origin) {
        if (ObjectTypeUtils.isBasicType((Object)origin) || origin instanceof byte[]) {
            return origin;
        }
        return JsonUtils.toJson((Object)origin);
    }

    default public MediaType contentType(ServerWebExchange exchange, Object formatted) {
        Object webHandlerClientResponse = exchange.getAttribute("webHandlerClientResponse");
        if (Objects.nonNull(webHandlerClientResponse) && webHandlerClientResponse instanceof HttpClientResponse) {
            HttpClientResponse httpClientResponse = (HttpClientResponse)webHandlerClientResponse;
            String contentType = httpClientResponse.responseHeaders().get("Content-Type");
            return Optional.ofNullable(contentType).map(MediaType::parseMediaType).orElse(MediaType.APPLICATION_JSON);
        }
        ResponseEntity fluxResponseEntity = (ResponseEntity)exchange.getAttribute("webHandlerClientResponse");
        if (Objects.nonNull(fluxResponseEntity) && Optional.ofNullable(fluxResponseEntity.getHeaders().getContentType()).isPresent()) {
            return fluxResponseEntity.getHeaders().getContentType();
        }
        return MediaType.APPLICATION_JSON;
    }

    default public T error(ServerWebExchange exchange, int code, String message, Object object) {
        return this.error(code, message, object);
    }

    default public T error(int code, String message, Object object) {
        return null;
    }
}

