/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import sun.misc.Unsafe;

public class BeanAccessor {
    private static Unsafe unsafe;
    private static Map<Class<?>, Map<String, Field>> beaninfoMap;
    private static Map<Class<?>, Map<String, Long>> beanFieldOffsetMap;
    public static String SERIAL_VERSION_UID;
    public static String FINAL;
    public static String STATIC;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Unsafe getUnsafeInstance() {
        if (unsafe != null) {
            return unsafe;
        }
        Class<BeanAccessor> clazz = BeanAccessor.class;
        synchronized (BeanAccessor.class) {
            if (unsafe == null) {
                unsafe = BeanAccessor.getUnsafe();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return unsafe;
        }
    }

    public static Unsafe getUnsafe() {
        Unsafe value;
        try {
            Class<?> clazz = Class.forName("sun.misc.Unsafe");
            Field field = clazz.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            value = (Unsafe)field.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException("error to get theUnsafe", e);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Map<String, Field> getBeanFieldMap(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (beaninfoMap == null) {
            Class<BeanAccessor> clazz2 = BeanAccessor.class;
            // MONITORENTER : com.qq.tars.common.util.BeanAccessor.class
            if (beaninfoMap == null) {
                beaninfoMap = new HashMap();
            }
            // MONITOREXIT : clazz2
        }
        if (beaninfoMap == null) {
            return null;
        }
        Map<String, Field> fieldMap = beaninfoMap.get(clazz);
        if (fieldMap != null) return fieldMap;
        Class<?> clazz3 = clazz;
        // MONITORENTER : clazz3
        fieldMap = beaninfoMap.get(clazz);
        if (fieldMap == null) {
            Field[] fields = clazz.getDeclaredFields();
            fieldMap = new LinkedHashMap<String, Field>(fields.length);
            for (Field field : fields) {
                fieldMap.put(field.getName(), field);
            }
            beaninfoMap.put(clazz, fieldMap);
        }
        // MONITOREXIT : clazz3
        return fieldMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static long getBeanFieldOffset(Class<?> clazz, String fieldName) {
        Long result;
        Map<String, Long> offsetMap;
        if (clazz == null) return -1L;
        if (fieldName == null) {
            return -1L;
        }
        if (beanFieldOffsetMap == null) {
            Class<BeanAccessor> clazz2 = BeanAccessor.class;
            // MONITORENTER : com.qq.tars.common.util.BeanAccessor.class
            if (beanFieldOffsetMap == null) {
                beanFieldOffsetMap = new HashMap();
            }
            // MONITOREXIT : clazz2
        }
        if ((offsetMap = beanFieldOffsetMap.get(clazz)) == null) {
            Class<?> clazz3 = clazz;
            // MONITORENTER : clazz3
            offsetMap = beanFieldOffsetMap.get(clazz);
            if (offsetMap == null) {
                Map<String, Field> fieldMap = BeanAccessor.getBeanFieldMap(clazz);
                offsetMap = new HashMap<String, Long>(fieldMap.size());
                for (String key : fieldMap.keySet()) {
                    Field field = fieldMap.get(key);
                    String modifiers = Modifier.toString(field.getModifiers());
                    if (field.getName().equals(SERIAL_VERSION_UID) || modifiers.contains(FINAL) || modifiers.contains(STATIC)) continue;
                    long offset = BeanAccessor.getUnsafeInstance().objectFieldOffset(field);
                    offsetMap.put(key, offset);
                }
                beanFieldOffsetMap.put(clazz, offsetMap);
            }
            // MONITOREXIT : clazz3
        }
        if (offsetMap == null) {
            return -1L;
        }
        Long l = result = offsetMap.get(fieldName);
        if (result == null) {
            return -1L;
        }
        long l2 = result;
        return l2;
    }

    public static Object getBeanValue(Object bean, String fieldName) {
        if (bean == null || fieldName == null) {
            return null;
        }
        Class<?> clazz = bean.getClass();
        Map<String, Field> fieldMap = BeanAccessor.getBeanFieldMap(clazz);
        Field field = fieldMap.get(fieldName);
        Unsafe unsafe = BeanAccessor.getUnsafeInstance();
        if (unsafe == null) {
            try {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                return field.get(bean);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        long offset = BeanAccessor.getBeanFieldOffset(clazz, fieldName);
        if (offset == -1L) {
            return null;
        }
        Class<?> type = field.getType();
        if (type == Boolean.TYPE) {
            return unsafe.getBoolean(bean, offset);
        }
        if (type == Byte.TYPE) {
            return unsafe.getByte(bean, offset);
        }
        if (type == Short.TYPE) {
            return unsafe.getShort(bean, offset);
        }
        if (type == Character.TYPE) {
            return Character.valueOf(unsafe.getChar(bean, offset));
        }
        if (type == Integer.TYPE) {
            return unsafe.getInt(bean, offset);
        }
        if (type == Long.TYPE) {
            return unsafe.getLong(bean, offset);
        }
        if (type == Float.TYPE) {
            return Float.valueOf(unsafe.getFloat(bean, offset));
        }
        if (type == Double.TYPE) {
            return unsafe.getDouble(bean, offset);
        }
        return unsafe.getObject(bean, offset);
    }

    public static void setBeanValue(Object bean, String fieldName, Object data) {
        long offset;
        if (bean == null || fieldName == null) {
            return;
        }
        Class<?> clazz = bean.getClass();
        Map<String, Field> fieldMap = BeanAccessor.getBeanFieldMap(clazz);
        Field field = fieldMap.get(fieldName);
        Unsafe unsafe = BeanAccessor.getUnsafeInstance();
        if (unsafe == null) {
            try {
                field.set(bean, data);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if ((offset = BeanAccessor.getBeanFieldOffset(clazz, fieldName)) == -1L) {
            return;
        }
        Class<?> type = field.getType();
        if (type == Boolean.TYPE) {
            unsafe.putBoolean(bean, offset, (Boolean)data);
        } else if (type == Byte.TYPE) {
            unsafe.putByte(bean, offset, (Byte)data);
        } else if (type == Short.TYPE) {
            unsafe.putShort(bean, offset, (Short)data);
        } else if (type == Character.TYPE) {
            unsafe.putChar(bean, offset, ((Character)data).charValue());
        } else if (type == Integer.TYPE) {
            unsafe.putInt(bean, offset, (Integer)data);
        } else if (type == Long.TYPE) {
            unsafe.putLong(bean, offset, (Long)data);
        } else if (type == Float.TYPE) {
            unsafe.putFloat(bean, offset, ((Float)data).floatValue());
        } else if (type == Double.TYPE) {
            unsafe.putDouble(bean, offset, (Double)data);
        } else {
            unsafe.putObject(bean, offset, data);
        }
    }

    static {
        SERIAL_VERSION_UID = "serialVersionUID";
        FINAL = "final";
        STATIC = "static";
    }
}

